#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define N 16
#define BASE 3

int main() {
    char lines[6][16 + 2]; // +2 for newline and null terminator
			   //
    for (int i = 0; i < 6; i++) {
	    if (fgets(lines[i], sizeof(lines[i]), stdin) == NULL) {
		    fprintf(stderr, "Error reading input.\n");
		    return EXIT_FAILURE;
	    }
	    lines[i][strcspn(lines[i], "\n")] = '\0';
    }
    int best = 33;
    int total = 1;
    for (int i = 0; i < 16; i++) {
        total *= 3;  // Compute 3^16
    }

    int arr[16];

    for (int num = 0; num < total; num++) {
        int temp = num;
        
        // Convert num to base 3 representation
        for (int i = 0; i < 16; i++) {
            arr[16 - 1 - i] = temp % 3;
            temp /= 3;
        }
        
        char prev = '@'; // Character before 'A' in ASCII
        int cost = 0;
        int valid = 1;

	for (int i = 0; i < 16; i++) {
		char current_char = '@';
		if (arr[i] == 0) {
			current_char = lines[0][i];
		} else if (arr[i] == 2) {
			current_char = lines[5][i];
		} else if (arr[i] == 1) {
			char min_side = '[';
			for (int l = 1; l <= 4; l++) {
				char cur_char = lines[l][i];
				if (cur_char >= prev && ((cur_char == 'Q') ? 'U' : cur_char) < min_side) {
					min_side = cur_char;
				}
			}
			if (min_side < '[') current_char = min_side;
		}
		cost += arr[i];
		if (current_char < prev) {
			valid = 0;
			break;
		}
		prev = current_char;
		if (prev == 'Q') {
			prev = 'U';
		}
	}

        if (valid) {
		best = (cost < best) ? cost : best;
        }
    }
    if (best == 33) printf("%s\n", "impossible");
    else printf("%d\n", best);

}

