import java.util.Random;
import java.util.Scanner;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;

public class SoccerSkillJava8 {
	public static void main(String[] args) {
		Scanner s = new Scanner(System.in);
		int N     = s.nextInt();
		double a  = s.nextDouble();
		double b  = s.nextDouble();
		int x     = s.nextInt();
		int y     = s.nextInt();

		int[] teamx = new int[N];
		int[] teamy = new int[N];

		// Showing off my Java 8 skills here
		IntStream.range(0, N).forEach((int i) -> {
			teamx[i] = s.nextInt();
			teamy[i] = s.nextInt();
		});

		shuffleArray(teamx, teamy);

		for(int i = 0; i < N; i++) {
			int dist_sq = (teamx[i] - x) * (teamx[i] - x) + (teamy[i] - y) * (teamy[i] - y);
			if(a * a <= dist_sq && dist_sq <= b * b) {
				System.out.print(teamx[i]);
				System.out.print(' ');
				System.out.print(teamy[i]);
				System.out.print(' ');
				System.out.print(Math.sqrt(dist_sq));
				System.out.print(' ');
				System.out.print(Math.atan2(teamy[i] - y, teamx[i] - x));
				System.out.println();
				System.exit(0);
			}
		}

		System.out.println("impossible");
	}

	// Implementing Fisher–Yates shuffle
	static void shuffleArray(int[] ar1, int[] ar2) {
		Random rnd = ThreadLocalRandom.current();
		for(int i = ar1.length - 1; i > 0; i--) {
			int index = rnd.nextInt(i + 1);
			// Simple swap
			int a      = ar1[index];
			ar1[index] = ar1[i];
			ar1[i]     = a;

			a          = ar2[index];
			ar2[index] = ar2[i];
			ar2[i]     = a;
		}
	}
}
