#include <cstdio>
#include <cstdlib>
#include <vector>
using namespace std;

struct Node {
    vector<int> adj;
};

class Graph {
  public:
    Graph(int V) {
        nodes_ = vector<Node>(V);
        V_ = V;
        E_ = 0;
    }

    int V() const { return V_; }
    int E() const { return E_; }

    void addEdge(int v, int w) {
        nodes_[v].adj.push_back(w);
        nodes_[w].adj.push_back(v);
        ++E_;
    }

    const vector<int> adj(int v) const { return nodes_[v].adj; }
    int degree(int v) const { return nodes_[v].adj.size(); }

  private:
    vector<Node> nodes_;
    int V_;
    int E_;
};

class ColoringBruteForce {
  public:
    ColoringBruteForce(const Graph& graph) {
        V_ = graph.V();
        color_ = vector<int>(V_);
        valid_ = dfs(graph, 0);
    }

    bool colorable() const { return valid_; }
    int color(int v) const { return color_[v]; }
      
  private:
    bool dfs(const Graph& graph, int v) {
        if (v == V_)
            return true;

        const vector<int>& adj = graph.adj(v);
        int num_adj = adj.size();
        for (int i = 1; i <= 4; ++i) {
            bool valid = true;
            for (int j = 0; j < num_adj; ++j)
                if (adj[j] < v && color_[adj[j]] == i) {
                    valid = false;
                    break;
                }
            if (valid) {
                color_[v] = i;
                if (dfs(graph, v+1))
                    return true;
            }
        }
        return false;
    }

    int V_;
    bool valid_;
    vector<int> color_;
};


int main(int argc, char *argv[]) {
    int N;
    scanf("%d", &N);

    Graph graph(N);
    int a, b;
    while (scanf("%d-%d", &a, &b) == 2)
        graph.addEdge(a-1, b-1);
    
    ColoringBruteForce coloring(graph);
    if (coloring.colorable())
        for (int i = 0; i < N; ++i)
            printf("%d %d\n", i+1, coloring.color(i));

    return EXIT_SUCCESS;
}
