#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
USO: ./check.py ../TestCases/X.in output
Da AssertionError si hay algo mal o imprime OK si esta todo bien.
"""

from __future__ import print_function
input = raw_input
range = xrange

import sys

if __name__ == '__main__':
    fin = open(sys.argv[1])
    fin_lines = fin.readlines()
    fin.close()
    
    fout = open(sys.argv[2])
    fout_lines = fout.readlines()
    fout.close()

    V = int(fin_lines[0])
    adj = [ [False]*V for _ in range(V) ]
    for line in fin_lines[1:]:
        line = line.strip()
        if not line: continue
        a, b = line.split('-')
        a = int(a)-1
        b = int(b)-1
        adj[a][b] = True
        adj[b][a] = True

    fout_lines = [line.strip() for line in fout_lines
                                   if line.strip()]
    assert len(fout_lines) == V, 'Wrong number of lines'

    color = []
    for i, line in enumerate(fout_lines):
        v, c = line.split()
        v = int(v)
        c = int(c)
        assert v == i+1, 'Wrong vertex line {}'.format(i+1)
        assert 1 <= c <= 4, 'Wrong color {} line {}'.format(i+1, c)
        color.append(c)

    for i, c in enumerate(color):
        for j in range(V):
            if adj[i][j]:
                assert color[i] != color[j], 'Wrong color {} lines {},{}'.format(c, i+1, j+1)

    print('OK')
