#include <algorithm>
#include <cstdio>
#include <cstdlib>
#include <map>
#include <set>
#include <string>
#include <vector>
using namespace std;

const int MAXWORDS = 20000;
string words[MAXWORDS]; // words by code
int counts[MAXWORDS];   // frequency of each word
int nwords = 0; // different words found

// hash table with a redblack tree for each bucket
const int HASH_SIZE = 100007;
vector< map<string, int> > word_codes(HASH_SIZE);

// hash function extracted from:
// http://stackoverflow.com/questions/114085/fast-string-hashing-algorithm-with-low-collision-rates-with-32-bit-integer
unsigned hash_string(const char * s) {
    unsigned hash = 0;
    for(; *s; ++s) {
        hash += *s;
        hash += (hash << 10);
        hash ^= (hash >> 6);
    }
    hash += (hash << 3);
    hash ^= (hash >> 11);
    hash += (hash << 15);
    return hash%HASH_SIZE;
}

// Return the word code of w or generate a new one
inline int get_code(const string& w) {
    // Looks in the hash table for the code
    int c = hash_string(w.c_str());
    map<string, int>::iterator r = word_codes[c].find(w);
    if (r == word_codes[c].end()) { // new word, generated a code
        int code = nwords++;
        words[code] = w;
        word_codes[c][w] = code;
        return code;
    } else // repeated word
        return r->second;
}

// Compare for the sort function()
// Sorts .first in decreasing order and .second in increasing order.
bool comparator(const pair<int, const string*>& lhs, const pair<int, const string*>& rhs) {
    if (lhs.first == rhs.first)
       return *lhs.second < *rhs.second;
    return lhs.first > rhs.first;
}

int main(int argc, char *argv[]) {
    // The words from the last 7 days
    vector<int> days[7];
    int LAST = 7-1;

    while (true) {
        char action_char[100];
        if (scanf("%s", action_char) != 1) break;

        string action = action_char;
        if (action == "<text>") { // read a text
            // remove the words from 7 days ago
            for (vector<int>::iterator it = days[0].begin();
                 it != days[0].end();
                 ++it) {
                --counts[*it];
            }

            // rotate the previous days vector
            for (int i = 0; i < LAST; ++i)
                days[i].swap(days[i+1]);
            days[LAST].clear();

            // read the words for the current day
            while (true) {
                char word_char[100];
                if (scanf("%s", word_char) != 1)
                    return -1;
                if (word_char[0] == '<') // </text>
                    break;
                string word = word_char;
                if (word.size() < 4)
                    continue;
                int code = get_code(word);
                days[LAST].push_back(code);
                counts[code]++;
            }
        
        } else { // print trending topics
            int how_many;
            if (scanf("%d%*s", &how_many) != 1)
                return -1;
            printf("<top %d>\n", how_many);
 
            // count how many words we have for each frequency
            int max_cnt = 0;
            vector<int> cnt(100000, 0);
            for (int i = 0; i < nwords; ++i) {
                cnt[counts[i]]++;
                max_cnt = max(max_cnt, counts[i]);
            }
            fprintf(stderr, "> %d\n", max_cnt);

            // calculate the lowest frequency we need to take
            int thres = max_cnt+1;
            while (thres > 0 && how_many > 0) {
                --thres;
                how_many -= cnt[thres];
            }
            thres = max(1, thres);

            // get all the words above the threshold
            vector<pair<int, const string*> > result;
            for (int i = 0; i < nwords; ++i)
                if (counts[i] >= thres)
                    result.push_back(pair<int, const string*>(counts[i], &words[i]));

            // prints the result in order
            sort(result.begin(), result.end(), comparator);
            for (vector<pair<int,const string*> >::iterator it = result.begin();
                 it != result.end();
                 ++it)
                    printf("%s %d\n", it->second->c_str(), it->first);
            printf("</top>\n");
        }
    } 
    return EXIT_SUCCESS;
}
