import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Scanner;



class ocurrenceWord implements Comparable<ocurrenceWord> {
	
	public String word;
	public int ocurrences;
	
	public ocurrenceWord(String w, int o) {
		word = w;
		ocurrences = o;
	}
	@Override
    public int compareTo(ocurrenceWord o) {
		
		if (o.ocurrences != ocurrences)
			return ocurrences < o.ocurrences? 1: -1;
		
		else 
			return word.compareTo(o.word);
		
		
        
    }
	
	
}


public class joan {

    static int MAXWORDS = 20000;
    static int MAXDAYS = 7;
    static int MAXOCURRENCES = 2000;

    
    
    public static int addWord(Hashtable<String, Integer> T,String []R, String w) {

        if (T.containsKey(w))
            return T.get(w);

        T.put(w, T.size());
        R[T.size()-1] = w;
        return T.size()-1;
    }

    public static void main(String []args){
        Scanner sc = new Scanner(System.in);

        int [][]mHist = new int[MAXDAYS][MAXWORDS];
        Hashtable<String, Integer> T = new Hashtable<String, Integer>();
        String []R = new String[MAXWORDS];
        int total_words = 0;
        int day = 0;

        while(sc.hasNext()) {

            String line = sc.next();

            if (line.equals("<text>")) {

                //Delete the current day
                for (int i = 0; i < T.size(); ++i) mHist[day][i] = 0;

                //System.out.println(String.format("Day %d Words %d", day, T.size()));
                String text = sc.next();

                while (!text.equals("</text>")){
                    // Readlines
                    //System.out.println(text);
                    if (text.length() >= 4) {
                        int word = addWord(T,R, text);
                        //int word = 0;
                        mHist[day][word]++;
                    }
                    text = sc.next();

                }
                day = (day+1)%MAXDAYS;

            }
            else if (line.equals("<top")){
                int n = sc.nextInt();
                sc.next();
                //Recover top words
                int []counting = new int[MAXOCURRENCES];
                int []ocurrences = new int[T.size()];
                //Accumulate words
                for (int i = 0; i < T.size(); ++i){
                    for (int d = 0; d < MAXDAYS; ++d){
                        ocurrences[i] += mHist[d][i]; 

                    }

                    counting[ocurrences[i]]++;
                }
                int count = 0;
                int c = MAXOCURRENCES-1;
                int threshold = MAXOCURRENCES;
                while(count < n && c > 0) {
                    count += counting[c];
                    threshold = c;
                    --c;
                }
                //System.out.println("Threshold "+threshold+ " "+T.size());
                ArrayList<ocurrenceWord> words = new ArrayList<ocurrenceWord>(); 
                // print the result
                System.out.println(String.format("<top %d>",n));
                for (int i = 0; i < T.size(); ++i) {
                    if (ocurrences[i] >= threshold)
                        words.add(new ocurrenceWord(R[i], ocurrences[i]));
                        //System.out.println(String.format("%s %d", R[i], ocurrences[i]));
                }
                
                Collections.sort(words);
                
                for(ocurrenceWord w:words){
                	System.out.println(String.format("%s %d", w.word, w.ocurrences));
                }
                
                System.out.println("</top>");
            }


        }
    }

}
