#!/bin/bash

make

for test_case in 1 2 3 4 5
do
    input="TestCases/${test_case}.in"
    output="TestCases/${test_case}.out"

    if [ ! -f ${output} ]
    then
        echo ""
        echo java SimpleSolution
        time java SimpleSolution < ${input} > ${output}
    fi

    echo ""
    echo ./JonSolution.exe
    time ./JonSolution.exe  < ${input} > kk.${test_case}

    diff ${output} kk.${test_case} >/dev/null 2>&1
    if [ $? -ne 0 ] ; then
        echo "Test case ${test_case}.1 fails with 'diff'!"
    fi
    result=$(./checkSolution.exe ${output} kk.${test_case})
    if [ ${result} != "Equal" ] ; then
        echo "Test case ${test_case} fails!"
        exit 1
    else
        echo "Test case ${test_case} OK!"
    fi

    echo ""
    echo ./JonSolution2.exe
    time ./JonSolution2.exe  < ${input} > kk.${test_case}

    diff ${output} kk.${test_case} >/dev/null 2>&1
    if [ $? -ne 0 ] ; then
        echo "Test case ${test_case}.2 fails with 'diff'!"
    fi
    result=$(./checkSolution.exe ${output} kk.${test_case})
    if [ ${result} != "Equal" ] ; then
        echo "Test case ${test_case} fails!"
        exit 1
    else
        echo "Test case ${test_case} OK!"
    fi

done

exit 0
