
#include <cstdio>
#include <cstdlib>
#include <cstring>

#include "MaxHeap.h"

class Word
{
public:
    char *word;
    int counter;

    Word( const char *w, int c )
    {
        word = new char [strlen(w)+1];
        strcpy( word, w );

        counter = c;
    }
    ~Word()
    {
        delete [] word;
    }

    bool equals( const Word * other )
    {
        return 0 == strcmp( this->word, other->word ) && this->counter == other->counter;
    }
    bool operator()( const Word * other ) const
    {
        return strcmp( this->word, other->word ) < 0;
    }

    int compareTo( const Word * other ) const
    {
        return strcmp( this->word, other->word );
    }
};

struct lt_word
{
    bool operator()(const Word* w1, const Word* w2) const
    {
        return strcmp(w1->word, w2->word) < 0;
    }
};

void loadFromInput( FILE *input, MaxHeap<Word> & q )
{
    char buffer[4096];
    int  counter;

    fscanf( input, "%s", buffer );
    if ( 0 != strcmp( buffer, "<top" ) ) return;
    fscanf( input, "%s", buffer );  // skip N>

    while( fscanf( input, "%s", buffer ) == 1 ) {

        if ( 0 == strcmp( buffer, "</top>" ) ) break;

        fscanf( input, "%d", &counter );

        q.push( new Word( buffer, counter ) );
    }
}


int main( int argc, char *argv[] )
{
    if ( argc < 3 ) return EXIT_FAILURE;

    FILE *one = fopen( argv[1], "r" ); if ( one == NULL ) return EXIT_FAILURE;
    FILE *two = fopen( argv[2], "r" ); if ( two == NULL ) return EXIT_FAILURE;

    MaxHeap<Word>  q1, q2;

    bool areEquals = false;

    loadFromInput( one, q1 );
    loadFromInput( two, q2 );

    if ( q1.size() != q2.size() ) { printf( "Different\n" ); return EXIT_FAILURE; }

    while( q1.size() == q2.size() && q1.size() > 0  &&  q2.size() > 0 ) {

        areEquals = true;
        while( q1.size() > 0  &&  q2.size() > 0 ) {

            Word *w1 = q1.top(); q1.pop();
            Word *w2 = q2.top(); q2.pop();

            if ( ! w1->equals( w2 ) ) { areEquals = false; }

            delete w1;
            delete w2;
        }
        while( q1.size() > 0 ) { delete q1.top(); q1.pop(); }
        while( q2.size() > 0 ) { delete q2.top(); q2.pop(); }

        if ( !areEquals ) break;
        
        loadFromInput( one, q1 );
        loadFromInput( two, q2 );
        if ( q1.size() != q2.size() ) { printf( "Different\n" ); return EXIT_FAILURE; }
    }

    if ( areEquals ) printf( "Equal\n" ); else { printf( "Different\n" ); return EXIT_FAILURE; }

    return EXIT_SUCCESS;
}
