
import java.util.*;

public class TestCaseGenerator
{
    public static int random( Random r, int a, int b )
    {
        return Math.min(a,b) + r.nextInt( Math.abs(b-a)+1 );        
    }
    public static void main( String args[] )
    {
        final int MAX_NUMBER_OF_DAYS  =  100;   //  1000;
        final int MAX_NUMBER_OF_WORDS = 5000;   // 20000;
        final int MAX_WORDS_PER_DAY   = 1000;   // 10000;

        Random r = new Random();

        int numberOfDays  = random( r,   20, MAX_NUMBER_OF_DAYS );
        int numberOfWords = random( r, 1000, MAX_NUMBER_OF_WORDS );

        String words[] = generateVocabulary( numberOfWords, r );

        for( int i=0; i < numberOfDays; i++ ) {
            
            System.out.println( "<text>" );
            int W = random( r, 100, MAX_WORDS_PER_DAY );
            while( --W >= 0 ) {
                System.out.print( ' ' + words[ r.nextInt(numberOfWords) ] );
                if ( W % 10 == 0 ) System.out.println();
            }
            System.out.println( "</text>" );

            if ( r.nextInt( 100 ) < 80 ) System.out.printf( "\n<top %d />\n\n", random( r, 1, 20 ) );
        }
    }

    private static String [] generateVocabulary( int W, Random r )
    {
        String words [] = new String [W];

        for( int i=0; i < W; i++ ) {
            boolean isRepeated;
            do {
                isRepeated=false;

                words[i] = generateWord( random( r, 1, 10 ), r );

                for( int j=0; j < i && !isRepeated; j++ ) 
                    isRepeated = words[j].equals( words[i] );

            } while( isRepeated );

        }

        return words;
    }

    private static String generateWord( int length, Random r )
    {
        int setSize = 'z'-'a'+1;

        String word = "";

        while( --length >= 0 ) word += (char)('a' + r.nextInt(setSize) );

        return word;
    }
}
