
/**
 * This class shown a naive solution for the problem Trend Topic
 * whose running time will exceed the limit.
 * Is not a valid solution for the contest, it is used by problem
 * setters for checking the solutions provided.
 */

import java.util.*;

class Word
    implements Comparable
{
    private String  word;
    private int     counter;

    public Word( String word, int counter )
    {
        this.word = word;
        this.counter = counter;
    }

    public String getWord() { return word; }
    public int    getCounter() { return counter; }

    public void increaseCounter() { ++counter; }
    public void decreaseCounter() { --counter; }

    public int compareTo( Word other )
    {
        if ( this.counter > other.counter ) return -1;
        if ( this.counter < other.counter ) return  1;
        return this.word.compareTo( other.word );
    }
    public int compareTo( Object other )
    {
        if ( other instanceof Word )
            return this.compareTo( (Word)other );
        else
            return -1;
    }
}

public class SimpleSolution
{
    public static void main( String args[] )
        throws Exception
    {
        Hashtable<String,Word>  map = new Hashtable<String,Word>();

        Scanner sf = new Scanner( System.in );

        Queue<LinkedList<String>>  days = new LinkedList<LinkedList<String>>();

        while( sf.hasNext() ) {

            String token = sf.next();

            if ( token.equals( "<text>" ) ) {

                LinkedList<String> today = new LinkedList<String>();
                days.add( today );

                while( sf.hasNext() ) {
                    token = sf.next();

                    if ( token.equals( "</text>" ) ) break;

                    if ( token.length() >= 4 ) {
                        if ( map.containsKey( token ) ) {
                            Word word = map.get(token);
                            word.increaseCounter();
                        } else {
                            map.put( token, new Word( token, 1 ) );
                        }

                        today.add( token );
                    }
                }

                if ( days.size() > 7 ) {
                    LinkedList<String> oldestDay = days.remove();

                    for( String token1 : oldestDay ) {
                        Word word = map.get(token1);
                        if ( word.getCounter() <= 0 ) throw new RuntimeException( "Impossible situation! An important hidden error exists in this program!" );
                        word.decreaseCounter();
                    }
                }

            } else if ( token.equals( "<top" ) ) {

                int N = sf.nextInt();
                token = sf.next();
                if ( ! token.equals( "/>" ) ) throw new Exception( "Wrong input!" );

                Word topN[] = new Word [N+1];

                for( Word word : map.values() ) {

                    int n = N;
                    while( n > 0  &&  (topN[n-1] == null || word.getCounter() > topN[n-1].getCounter()) ) {
                        topN[n] = topN[n-1];
                        --n;
                    }
                    if ( n < N ) topN[n] = word;
                }

                int minCounter = topN[N-1].getCounter();

                Word listToShow[] = map.values().toArray( new Word [1] );
                Arrays.sort( listToShow );

                System.out.printf( "<top %d>\n", N );
                for( Word word : listToShow ) {
                    if ( word.getCounter() < minCounter ) break;
                    System.out.printf( "%s %d\n", word.getWord(), word.getCounter() );
                }
                System.out.printf( "</top>\n" );
            }
        }
    }
}
