
#if !defined( __MAXHEAP_H ) 
#define  __MAXHEAP_H 


template <class T>
class MaxHeap
{
private:
    int       heapSize, heapMaxSize, exp;
    T       **vector;


    void maxHeapify( int pos )
    {
        int left = pos << 1;
        int right = left+1;
        int largest = pos;

        if ( left  <= heapSize  &&  vector[left ]->compareTo( vector[largest] ) < 0 ) largest = left;
        if ( right <= heapSize  &&  vector[right]->compareTo( vector[largest] ) < 0 ) largest = right;

        if ( largest != pos ) {

            T * tmp = vector[pos];
            vector[pos] = vector[largest];
            vector[largest] = tmp;

            maxHeapify( largest );
        }
    }
    void increaseKey( int pos )
    {
        while( pos > 1 ) {
            int parent = pos >> 1;

            if ( vector[pos]->compareTo( vector[parent] ) < 0 ) {

                T * tmp = vector[pos];
                vector[pos] = vector[parent];
                vector[parent] = tmp;

                pos = parent;
            } else {
                pos = 0;
            }
        }
    }

    public:

    MaxHeap()
    {
        exp = 15;
        heapMaxSize = (1 << exp)-1;
        vector = new T * [heapMaxSize+1];
        heapSize = 0;
    }
    ~MaxHeap()
    {
        clear();
        delete [] vector;
    }

    bool empty()
    {
        return 0 == heapSize;
    }
    int  size()
    {
        return heapSize;
    }
    void clear()
    {
        while( heapSize > 0 ) delete vector[heapSize--];
    }

    T * top()
    {
        return vector[1];
    }
    T * pop()
    {
        T *h = vector[1];

        vector[1] = vector[heapSize--];
        maxHeapify( 1 );

        return h;
    }
    T * get( int pos )
    {
        return vector[pos];
    }
    /*
       void substitute( T *h, int pos )
       {
       vector[pos] = h;
       h->setPosEnMaxHeap( pos );
       increaseKey( pos );
       }
     */
    void push( T * h )
    {
        if ( heapSize == heapMaxSize ) { // Se dobla el tamaño de la lista, no debería pasar más de una vez, si es que esto ocurre.
            ++exp;
            heapMaxSize = (1 << exp)-1;
            T **temp = new T * [heapMaxSize+1];
            for( int i=1; i <= heapSize; i++ ) temp[i] = vector[i];

            delete [] vector;
            vector = temp;
        }

        vector[++heapSize] = h;
        increaseKey( heapSize );
    }
};

#endif // __MAXHEAP_H
