#include <cstdio>
#include <cmath>
#include <cfloat>
#include <cstring>
#include <string>
#include <map>
#include <list>
#include <vector>
#include <stack>

/*
#define MAXN 1000
#define MAXE 1500
*/
#define MAXN 3000
#define MAXE 10000

using namespace std;

struct edge;

//Data structures for creating a graph
struct node{
  int f;    //floor
  int x,y;  //(x,y)

  list<edge*> link;
};

struct edge{
  int   n;
  float d;
};


void path(node *G, int N, int a, int b);

int main(int argc, char *argv[]) {

  int N, M;

  scanf("%d %d", &N, &M);

  node graph[MAXN];
  edge links[MAXE*2];

  int f, x, y, n1, n2;
  char str[512];
  for(int i=0; i<N; i++) {
    scanf("%d %d %d", &f, &x, &y);

    //create place
    //printf("place %d: %d %d %d %s\n", i, f, x, y, str);
    graph[i].f = f * 5;
    graph[i].x = x;
    graph[i].y = y;
  }

  for(int i=0; i<M; i++) {
    scanf("%d %d %s", &n1, &n2, str);

    //create connection (p1, p2) type "str"
    //printf("connection: %s %s %s\n", p1, p2, str);
    //int n1 = name2key[p1];
    //int n2 = name2key[p2];

    links[2*i].n   = n2;
    links[2*i+1].n = n1;

    //Euclidean distance in both directions
    // walking, stairs
    links[2*i].d = links[2*i+1].d = 
      sqrt( (graph[n1].f - graph[n2].f)*(graph[n1].f - graph[n2].f)
	    + (graph[n1].x - graph[n2].x)*(graph[n1].x - graph[n2].x) 
	    + (graph[n1].y - graph[n2].y)*(graph[n1].y - graph[n2].y) );
   
    if( !strcmp(str, "escalator") ) { 
      links[2*i].d   = 1;
      links[2*i+1].d *= 3.0;
    } else if ( !strcmp(str, "lift") ) {
        links[2*i].d = 1;
        links[2*i+1].d = 1;
    }

    graph[ n1 ].link.push_back( &links[2*i] );
    graph[ n2 ].link.push_back( &links[2*i+1] );
  }

  int Q;
  scanf("%d", &Q);
  for (int q = 0; q < Q; ++q) {
    scanf("%d %d", &n1, &n2);
    //printf("query: %s -> %s\n", p1, p2);

    //Compute and print shortest path from p1 to p2
    path(graph, N, n1, n2);
  }

  return 0;
}

void path(node *G, int N, int a, int b) {

  //Dijkstra algorithm
  float dist[MAXN];
  int   pred[MAXN];
  bool  vist[MAXN];

  for(int i=0; i<N; i++) {
    dist[i] = FLT_MAX;
    vist[i] = false;
  }

  dist[a] = 0;
  pred[a] = -1; //No predecessor

  int no_vist = N;
  while( no_vist > 0 ) {
    float dmin = FLT_MAX;
    int place = -1;

    //Get the minimum distance from the not visited nodes (could be faster with a minHeap)
    for(int i=0; i<N; i++)
      if( !vist[i] && dist[i] < dmin ) {
	dmin = dist[i];
	place = i;
      }

    //If we have already reached the end node -> break
    if( place == b ) break;

    no_vist--;
    vist[place] = true;

    for(list<edge*>::iterator it=G[place].link.begin(); it!=G[place].link.end(); it++) {
      if( dist[place] + (*it)->d < dist[(*it)->n] ) {
	dist[(*it)->n] = dist[place] + (*it)->d;
	pred[(*it)->n] = place;
      }
    }
  }

//  fprintf(stderr, "%lf\n", dist[b]);

  //Get solution (reversed)
  stack<int> solution;
  for(int i=b; i>=0; i=pred[i])
    solution.push( i );

  //Print solution
  while( solution.size() > 1 ) {
    int place = solution.top(); solution.pop();
    printf("%d ", place);
  }
  printf("%d\n", solution.top());
}
