
import java.util.*;

public class JonSolution
{
    private static final double INFINITY = 9.9999e+300;
    private static final double EPSILON = 1.0e-15;

    private Place                       places[];
    private Hashtable<String,Integer>   nameToIndex; // Hash table to map place names with their index

    private double                      direct_distances[][];
    private double                      distances[][];
    private int                         bestPathTo[][];


    public JonSolution()
    {
        nameToIndex = new Hashtable<String,Integer>();        
        places = null;
    }

    public Place [] getPlaces()
    {
        return places;
    }
    public double [][] getDirectDistances()
    {
        return direct_distances;
    }
    public int getIndexOf( String placeName )
    {
        return nameToIndex.get( placeName );
    }

    public void loadFromScanner( Scanner sf )
    {
        int N = sf.nextInt();
        int M = sf.nextInt();

        places = new Place [N];
        direct_distances = new double [N][N];
        distances = new double [N][N];
        bestPathTo = new int [N][N];

        for( int i=0; i < N; i++ ) {
            direct_distances[i][i] = 0.0;
            bestPathTo[i][i] = i;
            for( int j=i+1; j < N; j++ ) {
                direct_distances[i][j] = direct_distances[j][i] = INFINITY;
                bestPathTo[i][j] = bestPathTo[j][i] = -1;
            }
        }

        for( int n=0; n < N; n++ ) {
            places[n] = new Place( sf );
            nameToIndex.put( places[n].getName(), n );
            places[n].setPosInArray( n );
        }

        for( int m=0; m < M; m++ ) {

//            String fromName = sf.next(); int from = nameToIndex.get( fromName );
//            String   toName = sf.next(); int   to = nameToIndex.get(   toName );
            int from = sf.nextInt();
            int to   = sf.nextInt();
            String typeName = sf.next();


            // Sanity check
            if ( direct_distances[from][to] != INFINITY ||  direct_distances[to][from] != INFINITY )
                // throw new RuntimeException( "Connection appears more than once: " + fromName + " --> " + toName + " (" + typeName + ")"  );
                throw new RuntimeException( "Connection appears more than once: " + from + " --> " + to + " (" + typeName + ")"  );

            places[from].addNeighbour( places[to] );
            places[to].addNeighbour( places[from] );

            direct_distances[from][to] = direct_distances[to][from] = places[from].distance( places[to] );

            if ( typeName.equals( "escalator" ) ) {
                direct_distances[from][to] = 1.0;
                direct_distances[to][from] *= 3.0;
            } else if ( typeName.equals( "lift" ) ) {
                direct_distances[from][to] = 1.0;
                direct_distances[to][from] = 1.0;
            }

            bestPathTo[from][to] = from;
            bestPathTo[to][from] = to;
        }
        for( int i=0; i < places.length; i++ ) {
            for( int j=0; j < places.length; j++ ) {
                distances[i][j] = direct_distances[i][j];
            }
        }
    }

    public void Floyd_Warshall_modified()
    {
        int changes;
        do {
            changes=0;

            for( int k=0; k < places.length; k++ ) {
                for( int i=0; i < places.length; i++ ) {
                    for( int j=0; j < places.length; j++ ) {

                        if ( i != j && i != k && j != k ) {

                            double through_k = distances[i][k] + direct_distances[k][j];
                            if ( through_k < distances[i][j] - EPSILON ) {
                                distances[i][j] = through_k;
                                bestPathTo[i][j] = k;
                                ++changes;
                            }
                        }
                    }
                }
            }

        } while( changes > 0 );
    }

    public void sanity_check()
    {
        int counter=0;
        for( int i=0; i < places.length; i++ ) {
            for( int j=0; j < places.length; j++ ) {
                if ( distances[i][j] == INFINITY || bestPathTo[i][j] == -1 ) {
                    System.err.println( "No existing path from " + places[i].getName() + " to " + places[j].getName() );
                    ++counter;
                }
            }
        }
        if ( counter > 0 ) throw new RuntimeException( "Several places are isolated!" );
    }

    public void bestPath( String fromName, String toName )
    {
        int from = nameToIndex.get( fromName );
        int   to = nameToIndex.get(   toName );

        //System.out.printf( " %10.4f ", distances[from][to] );

        bestPath( from, to );
        System.out.println();
    }
    public void bestPath( int from, int to )
    {
        if ( from != to ) {
            bestPath( from, bestPathTo[from][to] );
            System.out.print( " " + to );
        } else {
            System.out.print( from );
        }
    }

    public static void main( String args[] )
    {
        Scanner input = new Scanner( System.in );

        JonSolution solution = new JonSolution();

        solution.loadFromScanner( input );
        solution.Floyd_Warshall_modified();
        solution.sanity_check();

        int Q = input.nextInt();

        while( --Q >= 0  &&  input.hasNext() ) {
/*
            String from = input.next();
            String   to = input.next();
*/
            int from = input.nextInt();
            int   to = input.nextInt();

            solution.bestPath( from, to );
            System.out.println();
        }
    }
}
