#!/bin/bash 

make

TestCasesDir=TestCases

for GZ_INPUT in ${TestCasesDir}/*.in #${TestCasesDir}/*.in.gz
do
    INPUT=${GZ_INPUT%%.gz}
    if [ -f ${INPUT}.gz ] ; then
        zcat ${GZ_INPUT} >${INPUT}
    fi

    OUTPUT_CPP="${INPUT%%.in}.out"
    OUTPUT_JAVA_BASIC="${INPUT%%.in}jB.out"
    OUTPUT_JAVA_ADVANCED="${INPUT%%.in}jA.out"

    echo ""
    echo $INPUT $OUTPUT_CPP
    
    echo -e "\nJAVA Basic Solution"
    time java BasicSolution       <${INPUT} >${OUTPUT_JAVA_BASIC}
    echo -e "\nJAVA Advanced Solution"
    time java AdvancedSolution    <${INPUT} >${OUTPUT_JAVA_ADVANCED}
    echo -e "\nC++ Solution"
    time ./solution.exe           <${INPUT} >${OUTPUT_CPP}

    if [ -f ${INPUT}.gz ] ; then 
        rm -f ${INPUT}
    fi

    diff ${OUTPUT_JAVA_BASIC} ${OUTPUT_JAVA_ADVANCED} >diff.out 2>diff.err
    if [ $? -ne 0 ] ; then
        echo "Differences between ${OUTPUT_JAVA_BASIC}  and  ${OUTPUT_JAVA_ADVANCED}"
        exit 1
    fi

    diff ${OUTPUT_JAVA_BASIC} ${OUTPUT_CPP} >diff.out 2>diff.err
    if [ $? -ne 0 ] ; then
        echo "Differences between ${OUTPUT_JAVA_BASIC}  and  ${OUTPUT_CPP}"
        exit 2
    fi
done

echo ""
echo "No differences were found!!"
echo ""

rm -f diff.err diff.out

make clean

exit 0
