#!/bin/bash

test_dir="TestCases"

for file in ${test_dir}/*.in ${test_dir}/*.in.gz
do
    echo "Test file $file"

    if [ "${file}" = "${file%.gz}" ]
    then
        cat_command="cat"
    else
        cat_command="zcat"
    fi

    ${cat_command} ${file} | awk -f check-inputs.awk | sort -k 2 | sort -nk 1 | uniq | tail

    echo "Non letters"
    ${cat_command} ${file} | tr [A-Za-z] " " | awk '{ for( i=1; i <= NF; i++ ) print $i ; }' | sort | uniq 

    ${cat_command} ${file} | awk -f check-inputs.awk | sort -k 2 | sort -nk 1 | uniq | wc
done
