
import java.util.*;
import java.io.*;

public class TestCasesGenerator
{
    public static void main( String args[] ) 
    {
        int numberOfCases = 10;
        int numberOfWords = -1;
        int numberOfKnownSentences = -1;
        int numberOfUnknownSentences = -1;
        int repetitionsOfUnknownSentences = 1;

        for( int i=0; i < args.length; i++ ) {
            
            if ( "--number-of-cases".equals( args[i] ) ) {

                numberOfCases = Integer.parseInt( args[++i] );

            } else if ( "--number-of-words".equals( args[i] ) ) {

                numberOfWords = Integer.parseInt( args[++i] );

            } else if ( "--number-of-known-sentences".equals( args[i] ) ) {

                numberOfKnownSentences = Integer.parseInt( args[++i] );

            } else if ( "--number-of-unknown-sentences".equals( args[i] ) ) {

                numberOfUnknownSentences = Integer.parseInt( args[++i] );

            } else if ( "--repetitions-of-unknown-sentences".equals( args[i] ) ) {

                repetitionsOfUnknownSentences = Integer.parseInt( args[++i] );
            }
        }

        while( --numberOfCases >= 0 ) {

            TestCaseGenerator tcg = new TestCaseGenerator( numberOfWords,
                                                           numberOfKnownSentences,
                                                           numberOfUnknownSentences,
                                                           repetitionsOfUnknownSentences );

            tcg.toStream( System.out );
        }
    }
}
