
import java.util.*;

public class BasicSolution
{
    enum States { OUT, READING_PREVIOUS_KNOWLEDGE, PROCESSING_CONVERSATION };

    public static void main( String args[] )
    {
        Map<String,Integer> words = new HashMap<String,Integer>(),
                            nGrams = new HashMap<String,Integer>();
        String              buffer,
                            of, learnt, sentences,
                            knowledge;
        int                 level=2,
                            caseNumber=1;

        ArrayList<String>   sentence = new ArrayList<String>();
        ArrayList<String>   plainSentence = new ArrayList<String>();

        States              state;
        boolean             unknownSentence=false;
        char                lastChar;
        
        Scanner sf = new Scanner( System.in );
        
        state = States.OUT;

        while( sf.hasNext() ) {
            
            buffer = sf.next();

            switch( state ) {

                case OUT :
                    level = Integer.parseInt( buffer );
                    words = new HashMap<String,Integer>();
                    words.put( "joe", 1 );
                    nGrams = new HashMap<String,Integer>();
                    state = States.READING_PREVIOUS_KNOWLEDGE;
                    sentence.clear();
                    plainSentence.clear();
                    if ( caseNumber > 1 ) System.out.println();
                    System.out.println( "Learning case " + caseNumber );
                    ++caseNumber;
                    break;
                    
            
                case READING_PREVIOUS_KNOWLEDGE :
                case PROCESSING_CONVERSATION :

                    lastChar = buffer.charAt( buffer.length() - 1 );

                    if ( lastChar != '*' && lastChar != '#' ) {

                        String cleanCaseSensitiveWord = removeNonAlphaCharacters( buffer );

                        if ( cleanCaseSensitiveWord.length() > 0 ) {

                            String cleanWord = cleanCaseSensitiveWord.toLowerCase();

                            if ( !words.containsKey( cleanWord ) ) {
                                if ( state == States.PROCESSING_CONVERSATION )
                                    System.out.println( "What does the word \"" + cleanCaseSensitiveWord + "\" mean?" );

                                words.put( cleanWord, words.size()+1 );
                            }


                            sentence.add( cleanCaseSensitiveWord );
                            plainSentence.add( cleanWord );

                            if ( plainSentence.size() >= 2 ) {

                                for( int l=level; l>=2; l-- ) {

                                    int i = Math.max( 0, plainSentence.size()-l );
                                    String key = plainSentence.get(i);
                                    for( ++i ; i < plainSentence.size(); ++i ) key += " " + plainSentence.get(i);

                                    if ( !nGrams.containsKey( key ) ) {

                                        unknownSentence=true;
    //System.err.printf( "nGrams.put( %s, %d )\n", key, nGrams.size()+1 );
                                        nGrams.put( key, nGrams.size()+1 );
                                    }
                                }
                            }
                        }
                    }

                    if ( lastChar == '.' || lastChar == ':'
                      || lastChar == ',' || lastChar == ';' 
                      || lastChar == '?' || lastChar == '!'
                      || lastChar == '#' || lastChar == '*' ) {

                        if ( unknownSentence && state == States.PROCESSING_CONVERSATION  &&  sentence.size() > 0 ) {

                            String key = sentence.get(0);
                            for( int i=1 ; i < sentence.size(); ++i ) key += " " + sentence.get(i);

                            System.out.println( "What does the sentence \"" + key + "\" mean?" );
                        }
                        sentence.clear();
                        plainSentence.clear();
                        unknownSentence = false;
                    }

                    if ( lastChar == '#' ) state = States.OUT;
                    if ( lastChar == '*' ) state = States.PROCESSING_CONVERSATION;

                    break;
            } // switch( state )
        } // while()
    }

    private static String removeNonAlphaCharacters( String in )
    {
        String out = "";
        
        for( int i=0; i < in.length(); i++ ) {
            char ch = in.charAt(i);
            if ( Character.isLetter( ch ) || Character.isDigit( ch ) ) {
                out += ch;
            }
        }

        return out;
    }
}
