#pragma warning(disable:4786)
#include<iostream>
#include<time.h>
#include<cstdio>
#include<algorithm>
#include<vector>
#include<set>
#include<map>
#include<functional>
#include<string>
#include<cstring>
#include<cstdlib>
#include<queue>
#include<utility>
#include<fstream>
#include<sstream>
#include<cmath>
#include<stack>
#include<assert.h>
using namespace std;

#define MEM(a, b) memset(a, (b), sizeof(a))
#define CLR(a) memset(a, 0, sizeof(a))
#define MAX(a, b) ((a) > (b) ? (a) : (b))
#define MIN(a, b) ((a) < (b) ? (a) : (b))
#define ABS(X) ( (X) > 0 ? (X) : ( -(X) ) )
#define S(X) ( (X) * (X) )
#define SZ(V) (int )V.size()
#define FORN(i, n) for(i = 0; i < n; i++)
#define FORAB(i, a, b) for(i = a; i <= b; i++)
#define ALL(V) V.begin(), V.end()

typedef pair<int,int> PII;
typedef pair<double, double> PDD;
typedef vector<int> VI;

#define IN(A, B, C) assert( B <= A && A <= C)

//typedef int LL;
//typedef long long int LL;
//typedef __int64 LL;

#define EPS 1e-10
#define Z(x)	(ABS(x) < EPS)
#define D2(a,b)	(S(a.x-b.x) + S(a.y-b.y))
#define D1(a,b)	(mysqrt(D2(a,b)))

#define MAXN 1002

double pi = acos(-1.);

double mysqrt(double x)
{
	if(x < 0)	return 0;
	return sqrt(x);
}

double myasin(double x)
{
	if(x < -1)	return -pi/2.;
	if(x > 1)	return pi/2.;
	return asin(x);
}

struct Circle
{
	int x, y, r, xlo, xhi;
	int type;

	Circle(int _x, int _y, int _r, int _type)
	{
		x = _x;
		y = _y;
		r = _r;
		type = _type;
		xlo = x - r;
		xhi = x + r;
	}
};

#define OPEN 0
#define CLOSE 1

struct Event
{
	int type;
	double y1, y2, aa, y;	//aa = arcarea of the event's host circle
	Event(){}
	Event(int t,double yy1,double yy2,double aaa, double _y)
	{
		type = t;
		y1 = yy1;
		y2 = yy2;
		aa = aaa;
		y = _y;
	}
};

bool operator<(const Event &p,const Event &q){	//event sort function

	if(ABS(p.y - q.y) < EPS) return p.type < q.type;
	return p.y > q.y;

	double py = p.y1 + p.y2;
	double qy = q.y1 + q.y2;
	if(ABS(py-qy) < EPS)	return p.type < q.type;
	return py > qy;
}	//this is enough as, p.y1 > q.y1 <=> p.y2 > q.y2 (slicing)

//circles MUST intersect. returns only the 'x' of intersections
void getCircleIsects(Circle c1,Circle c2,double &x1,double &x2){
	if(c1.r < c2.r)swap(c1,c2);
	double d = D1(c1,c2);
	double a = ( S(c1.r) + S(d) - S(c2.r) )/(2.*d);
	double h = mysqrt( S(c1.r) - S(a) );
	x1 = c1.x + (a*(c2.x-c1.x) - h*(c2.y-c1.y))/d;
	x2 = c1.x + (a*(c2.x-c1.x) + h*(c2.y-c1.y))/d;
}

vector<double> vx,X;	//for slicing

int ne;
Event e[2*MAXN];			//events of arc open/close

int tos;
Event stacks[MAXN+1];		//stacks - remember earlier openings
double inarea[MAXN+1];	//stacks - calculate the area that is covered by inner circles

double ans[MAXN+1];		//ans[i] = total area that is covered by exactly i circles

double ringUnionArea(vector<Circle> &c){
	int i,j,k, n = c.size();
	double d,x1,x2;

	// << slicing start >>
	vx.clear();
	for(i=0;i<n;i++){		//center er x boshanor dorkar nai
		vx.push_back(c[i].x - c[i].r);
		vx.push_back(c[i].x + c[i].r);
	}
	//insert all possible x[intersections]
	for(i=0;i<n;i++)for(j=i+1;j<n;j++){
		d = D1(c[i],c[j]);
		if(D2(c[i],c[j]) >= S(c[i].r + c[j].r) || D2(c[i],c[j]) <= S(c[i].r - c[j].r) )
			continue;
		getCircleIsects(c[i],c[j],x1,x2);
		vx.push_back(x1);
		vx.push_back(x2);
	}
	sort(ALL(vx));

	X.clear();
	X.push_back(vx[0]);
	for(i=1;i<vx.size();i++)if( vx[i-1] < vx[i]+EPS )
		X.push_back(vx[i]);
	// << slcing end >>

	fprintf(stderr, ">>%d\n", SZ(X));
	double area = 0;
	double ret = 0;
	double xgap, dx1,dy1, dx2,dy2, x, y;
	double t1,t2;

	for(i=0;i<=n;i++)	//init ans[]
		ans[i] = 0;

	for(k=0;k+1<X.size();k++){	//for each X slice
		x1 = X[k];
		x2 = X[k+1];
		xgap = x2-x1;

		ne = 0;
		for(i=0;i<n;i++){	// 2 events for each circle
			if(x2 < c[i].xlo+EPS)	continue;
			if(c[i].xhi < x1+EPS)	continue;
			
			dx1 = x1-c[i].x;
			dy1 = mysqrt( S(c[i].r) - S(dx1) );
			
			dx2 = x2-c[i].x;
			dy2 = mysqrt( S(c[i].r) - S(dx2) );

			t1 = myasin(dx1/c[i].r);
			t2 = myasin(dx2/c[i].r);

			area = 0.5*S(c[i].r) * (ABS(t2-t1) - sin(ABS(t2-t1)));//    -   0.5*xgap*(dy1 + dy2);

			x = (dx1 + dx2)/2;
			y = mysqrt( S(c[i].r) - S(x) );

			if(c[i].type == 0)
			{
				e[ne++] = Event(OPEN, c[i].y+dy1, c[i].y+dy2, area + 0.5*xgap*(dy1 + dy2 + 2*c[i].y), c[i].y + y);
				e[ne++] = Event(CLOSE,c[i].y-dy1, c[i].y-dy2, + 0.5*xgap*(-dy1 - dy2 + 2*c[i].y) - area, c[i].y - y);
			}
			else
			{
				e[ne++] = Event(CLOSE, c[i].y+dy1, c[i].y+dy2, area + 0.5*xgap*(dy1 + dy2 + 2*c[i].y), c[i].y + y);
				e[ne++] = Event(OPEN , c[i].y-dy1, c[i].y-dy2, 0.5*xgap*(-dy1 - dy2 + 2*c[i].y) - area, c[i].y - y);
			}
		}
		if(ne==0)continue;
		sort(e,e+ne);

		for(i=0;i<=n;i++)inarea[i] = 0;		//init	the inner area sum

		tos = 0;
//		assert(e[0].type == OPEN && e[ne-1].type == CLOSE);
		for(i=0;i<ne;i++)
		{
			if(e[i].type == CLOSE)
			{
				if(tos == 1)
				{
					ret += stacks[tos-1].aa - e[i].aa;// + 0.5*xgap*((stacks[tos-1].y1 - e[i].y1) + (stacks[tos-1].y2 - e[i].y2));
				}

				tos--;

				assert(tos >= 0);
			}
			else
			{
				stacks[tos++] = e[i];
			}
		}
	}

	return ret;
}

vector<Circle> circle;

int main()
{
//	freopen("data.in", "r", stdin);
//	freopen("data.out", "w", stdout);
double st = clock();

	int T, ks;
	int x, y, D, d, i, n;
	double ans;
	 
	scanf("%d", &T);
	for(ks = 1; ks <= T; ks++)
	{
		fprintf(stderr, "%d\n", ks);
		circle.clear();

		scanf("%d", &n);
		for(i = 0; i < n; i++)
		{
			scanf("%d %d %d %d", &x, &y, &D, &d);

			circle.push_back(Circle(x, y, D + d, 0));
			if(d < D) circle.push_back(Circle(x, y, D - d, 1));
		}

		ans = ringUnionArea(circle);

		printf("Case %d: %.6lf\n", ks, ans);
	}
  double en= clock();
  fprintf(stderr, "%lf\n", (en - st)/CLOCKS_PER_SEC);

	return 0;
}
