#include <bits/stdc++.h>
using namespace std;
typedef long long int ll;
typedef double ld;
typedef vector<ll> vi;
typedef vector<vi> Graph;
// push_back insert lower_bound upper_bound erase 

//unionfind
struct Uf{
    vector<ll> p, r; // p=element's parent, r=rank
    Uf(ll n):p(n),r(n){ iota(p.begin(), p.end(), 0); }
    // finds representant of a's set
    ll find(ll a){ return p[a]==a ? a : p[a]=find(p[a]); }
    // unifies sets of a and b
    void uni(ll a, ll b){
        a = find(a);
        b = find(b);
        if(a==b)return;
        if(r[a]<r[b]) swap(a, b);
        p[b] = a;
        r[a] += r[a]==r[b];
    }
    // check if elements are in the same set
    bool same(ll a, ll b){ return find(a) == find(b); }
};
///unionfind

ll N,M;
Graph g;
vector<pair<ll,ll>> edges;
vi v, inv, big;

void check(ll idx, ll mx){
    mx = min(mx, M-idx);
    ll sz=0;
    Uf uf(2*mx);
    unordered_map<ll,ll> m;
    for(ll i=0; i<mx; ++i){
        auto &p=edges[idx+i];
        ll a=p.first;
        ll b=p.second;
        if(!m.count(a)) m[a]=sz++;
        if(!m.count(b)) m[b]=sz++;
        assert(sz <= 2*mx);
        a=m[a];
        b=m[b];
        if(uf.same(a,b)){
            v[idx]=idx+i;
            return;
        }
        uf.uni(a,b);
        if(idx+i == M-1){
            v[idx]=M;
            return;
        }
    }
    v[idx]=idx+mx;
    big[idx]=1;
}

int main(int argc, char **argv){
    cin >> N >> M;
    g = Graph(N);
    for(ll i=0; i<M; ++i){
        ll a, b;
        cin >> a >> b; --a; --b;
        edges.push_back({a,b});
        g[a].push_back(b);
        g[b].push_back(a);
    }
    ll Q; cin >> Q;
    vector<pair<ll,ll>> q(Q);
    for(auto &p:q) cin >> p.first >> p.second;
    for(auto &p:q) --p.first, --p.second;

    inv = v = big = vi(M, 0);
    /* ll bound=max(1,((int)ceil(sqrt(N)))); */
    ll bound=M;
    for(ll i=0; i<M; ++i) check(i, bound);

    /* cerr << "bound: " << bound << endl; */
    /* for(ll i=0; i<M; ++i){ cerr << v[i] << ' '; } cerr << endl; */
    /* for(ll i=0; i<M; ++i){ cerr << big[i] << ' '; } cerr << endl; */
    for(ll i=0, idx=0; i<M; ++i){ while(idx<v[i]){ inv[idx++]=i-1; } }
    /* vi lower(M); */
    vi lower(M+1);
    for(ll i=1; i<M+1; ++i) lower[i]=lower[i-1]+v[i-1]-(i-1);
    /* cerr<<"v  : ";for(ll n:v)cerr << n << ' ';cerr<<endl; */
    /* cerr<<"inv: ";for(ll n:inv)cerr << n << ' ';cerr<<endl; */
    /* cerr << "lower : "; for(ll n:lower)  cerr << n << ' ';cerr << endl; */

    for(auto &p:q){
        ll beg=p.first;
        ll end=max(beg, inv[p.second]+1);
        ll range = max(0ll,p.second+1-end);
        ll res=lower[end] - lower[beg] + range*(range+1)/2;
        /* cerr << p.first << "-" << p.second << "  b:" << beg << ", e:" << end << ", sum:" << (lower[end]-lower[beg]) << ", r:" << range << ", res:" << res << endl; */
        cout << res << endl;
    }
    return 0;
}
