#include <bits/stdc++.h>
using namespace std;
typedef long long int ll;
typedef double ld;
typedef vector<ll> vi;
typedef vector<vi> Graph;
// push_back insert lower_bound upper_bound erase 

#define SQRT_MULT (0.6)

//unionfind
struct Uf{
    vector<ll> p, r; // p=element's parent, r=rank
    unordered_map<ll,ll> fake_p;
    void clear_fake(){ fake_p.clear(); }
    Uf(ll n):p(n),r(n){ iota(p.begin(), p.end(), 0); }
    // finds representant of a's set
    ll find(ll a){ return p[a]==a ? a : p[a]=find(p[a]); }
    ll fake_find(ll a){
        a = find(a);
        return fake_p.count(a) ? fake_find(fake_p[a]) : a;
    }
    // unifies sets of a and b
    void fake_uni(ll a, ll b){
        a = fake_find(a);
        b = fake_find(b);
        if(a==b)return;
        /* if(r[a]<r[b]) swap(a, b); */
        fake_p[b]=a;
    }
    void uni(ll a, ll b){
        assert(fake_p.empty());
        a = find(a);
        b = find(b);
        if(a==b)return;
        if(r[a]<r[b]) swap(a, b);
        p[b] = a;
        r[a] += r[a]==r[b];
    }
    // check if elements are in the same set
    bool same(ll a, ll b){ return fake_find(a) == fake_find(b); }
};
///unionfind

ll N,M;
Graph g;
#define MXM 100007
pair<ll,ll> edges[MXM];
vi v, inv;

void check(ll cur_b, ll prev_b, ll bound){
    ll cur_e = v[prev_b];
    Uf uf(N);
    ll sz=0;
    for(ll i=cur_b; i<cur_e; ++i){
        auto &p=edges[i];
        ll a=p.first;
        ll b=p.second;
        uf.uni(a, b);
    }
    for(ll i=cur_e; i<=M; ++i){
        auto &p=edges[i];
        ll a=p.first;
        ll b=p.second;
        if(uf.same(a, b)){
            v[cur_b]=i;
        }
        for(ll j=cur_b-1; j>prev_b; --j){
            auto &pp=edges[j];
            ll aa=pp.first;
            ll bb=pp.second;
            if(uf.same(aa,bb)){
                break;
            }
            uf.fake_uni(aa,bb);
            v[j]=i;
        }
        uf.clear_fake();
        if(uf.same(a, b)) return;
        uf.uni(a, b);
    }
    v[cur_b]=M;
}

int main(int argc, char **argv){
    cin >> N >> M;
    g = Graph(N);
    for(ll i=0; i<M; ++i){
        ll a, b;
        cin >> a >> b; --a; --b;
        edges[i]={a,b};
        g[a].push_back(b);
        g[b].push_back(a);
    }
    edges[M]={0,0};
    ll Q; cin >> Q;
    vector<pair<ll,ll>> q(Q);
    for(auto &p:q) cin >> p.first >> p.second;
    for(auto &p:q) --p.first, --p.second;

    inv = v = vi(M, 0);
    ll bound = max(3,((int)ceil(SQRT_MULT * sqrt(M))));

    ll idx=0, last=0;
    while(idx<M){
        check(idx, last, bound);
        last=idx;
        idx=max(idx+1, min(v[idx]-1,idx+bound));
    }
    for(ll i=0; i<M-1; ++i) v[i+1]=max(v[i+1],v[i]);
    for(ll i=0, idx=0; i<M; ++i){ while(idx<v[i]){ inv[idx++]=i-1; } }
    vi lower(M+1);
    for(ll i=1; i<M+1; ++i) lower[i]=lower[i-1]+v[i-1]-(i-1);

    for(auto &p:q){
        ll beg=p.first;
        ll end=max(beg, inv[p.second]+1);
        ll range = max(0ll,p.second+1-end);
        ll res=lower[end] - lower[beg] + range*(range+1)/2;
        cout << res << endl;
    }
    return 0;
}
