#!/usr/bin/env python3
import math
EPS = 1e-6
w, h, sx, sy, ex, ey = [int(i) for i in input().split()]
inn = [[int(j) for j in input().split()] for i in range(h//2)]
m = [[0 for j in range(w)] for i in range(h)]

def EQ(a, b):
  global EPS
  if abs(a - b) <= EPS:
    return True
  return False

def flipX():
  global w, h, sx, sy, ex, ey, m
  sx = w - sx
  ex = w - ex
  for i in range(h):
    for j in range(w//2):
      t = m[i][j]
      m[i][j] = m[i][w - j - 1]
      m[i][w - j - 1] = t

def flipY():
  global w, h, sx, sy, ex, ey, m
  sy = h - sy
  ey = h - ey
  for i in range(h//2):
    for j in range(w):
      t = m[i][j]
      m[i][j] = m[h - i - 1][j]
      m[h - i - 1][j] = t

for i in range(h//2):
  for j in range(w//2):
    m[2*i + 1][2*j] = m[2*i][2*j + 1] = m[2*i + 1][2*j + 1] = m[2*i][2*j] = inn[i][j]
  
if sx > ex: flipX()
if sy > ey: flipY()

pts = []
for i in range(ex - sx + 1):
  if ex == sx: continue
  pts += [(sx + i, sy + i*(ey - sy) / (ex - sx))]

for i in range(ey - sy + 1):
  if ey == sy: continue
  pts += [(sx + i*(ex - sx) / (ey - sy), sy + i)]

pts = sorted(pts)
last = 0
lastHeight = 0
res = 0

for i in range(1, len(pts)):
  if EQ(pts[i][0], pts[last][0]) and EQ(pts[i][1], pts[last][1]):
    continue

  ax = math.floor(pts[last][0] + EPS)
  ay = math.floor(pts[last][1] + EPS)

  bx = math.floor(pts[i][0] + EPS)
  by = math.floor(pts[i][1] + EPS)

  lastHeight = m[ay][ax]

  if (EQ(bx, pts[i][0]) and EQ(by, pts[i][1]) and m[by-1][bx] > lastHeight
      and m[by][bx-1] > lastHeight):
    res += min(abs(lastHeight - m[by-1][bx]) + abs(m[by-1][bx] - m[by][bx])
              , abs(lastHeight - m[by][bx-1]) + abs(m[by][bx-1] - m[by][bx]))
  else:
    res += abs(m[by][bx] - lastHeight)

  last = i

res += math.sqrt((ex - sx)**2 + (ey - sy)**2)
print("{:.12f}".format(res))
