#include <bits/stdc++.h>
using namespace std;
typedef long long int ll;

struct Pt{ ll x,y,id; };
vector<vector<ll>> g;
vector<Pt> a;
map<pair<ll,ll>,ll> ids;

void connect(map<ll,set<ll>> &m, bool king){
    for(auto &p:m){
        auto it=p.second.begin();
        auto last=it; ++it;
        while(it!=p.second.end()){
            ll f=*it;
            ll t=*last;
            if(!king || max(abs(a[f].x-a[t].x),abs(a[f].y-a[t].y))==1){
                g[f].push_back(t);
                g[t].push_back(f);
            }
            ++it; ++last;
        }
    }
}

vector<bool> todo;
vector<pair<ll,ll>> res;

void dfs(ll id, ll par){
    for(ll n:g[id])if(todo[n]){
        todo[n]=false;
        dfs(n, id);
        res.push_back({n, id});
    }
}

int main(int argc, char **argv){
    ll N;
    char K;
    cin >> N >> K;
    ll sz=0;
    for(ll y=0; y<N; ++y){
        string s;cin>>s;
        for(ll x=0; x<N; ++x){
            char ch = s[x];
            if(ch!='.'){
                a.push_back({x,y,sz});
                ids[{x,y}]=sz;
                ++sz;
            }
        }
    }
    map<ll,set<ll>> r, c, rc, cr;
    for(Pt &p:a){
        r[p.x].insert(p.id);
        c[p.y].insert(p.id);
        rc[p.x+p.y].insert(p.id);
        cr[p.x-p.y].insert(p.id);
    }
    // build the graph
    g.assign(sz,{});
    if(K=='N'){ // knight
        vector<Pt> jumps;
        for(ll i=-2; i<=2; ++i)
            for(ll j=-2; j<=2; ++j)
                if(j*j+i*i==5) jumps.push_back({i,j,-1});
        for(Pt &p:a){
            ll from=p.id;
            for(Pt j:jumps){
                ll x=p.x+j.x;
                ll y=p.y+j.y;
                if(ids.count({x,y})){
                    ll to=ids[{x,y}];
                    g[from].push_back(to);
                }
            }
        }
    }
    if(K=='Q' || K=='K' || K=='R'){ // rows & columns
        connect(r, K=='K');
        connect(c, K=='K');
    }
    if(K=='Q' || K=='K' || K=='B'){ // diagonals
        connect(cr, K=='K');
        connect(rc, K=='K');
    }

    todo=vector<bool>(sz, true);
    const ll START=0;
    todo[START]=false;
    dfs(START,START);
    if(res.size()==sz-1){
        cout<<"YES\n";
        for(auto &p:res){
            Pt f=a[p.first];
            Pt t=a[p.second];
            cout << f.y+1 << ' ' << f.x+1 << ' '  << t.y+1 << ' ' << t.x+1 << endl;
        }
    }else{
        cout<<"NO\n";
    }
    return 0;
}
