#!/usr/bin/env python
import sys
import functools

# n g
# 15 6

# 0 0 1 1 2 2 3 3 3 5 5 5 7 13
# Python3 program to print DFS traversal
# from a given given graph
from collections import defaultdict

class Node:
	def __init__(self, parent, value):
		self.parent = parent
		self.value = value

	def value(self):
		return self.value

	def parent(self):
		return self.parent

	def __str__(self):
		return "Node(parent:#{}, value:#{})".format(self.parent, self.value)

	def __repr__(self):
		return self.__str__()


class Tree:
	# Constructor
	def __init__(self):
		self.graph = defaultdict(list)
		self.guards = []
		self.c_guards = []

	def add_child(self, u, v):
		self.graph[u].append(Node(u, v))

	def is_leaf(self, v):
		return len(self.graph[v]) < 1

	def DFSUtil(self, v, visited):
		# print(self.graph)
		# Mark the current node as visited
		# and print it
		visited.add(v.value)
		print(v.value)
		if self.is_leaf(v.value):
			print("is_leaf: #{}".format(v.value))
			self.print_state()
			if not ((v.parent in self.c_guards) or (v.parent in self.guards)):
				self.guards.append(v.value)
				self.c_guards.append(v.parent)
				self.print_state()
		# Recur for all the vertices
		# adjacent to this vertex
		for neighbour in self.graph[v.value]:
			if neighbour.value not in visited:
				self.DFSUtil(neighbour, visited)

		if v.value in self.c_guards:
			print("#{} in c_guards".format(v.value))
			self.print_state()
			if not functools.reduce(lambda a, b: a and b, [(x.value in self.guards or x.value in self.c_guards) for x in self.graph[v.value]]):
				self.guards.append(v.value)
				self.c_guards.append(v.parent)
			else:
				self.c_guards.append(v.parent)
			self.print_state()

	def DFS(self, v):
		visited = set()
		self.DFSUtil(v, visited)

	def get_guards(self):
		return self.guards

	def print_state(self):
		print("guards:#{}, c_guards:#{}".format(self.guards, self.c_guards))

def will_defend():
	pass

n,k = [int(v) for v in sys.stdin.readline().split()]
h = [int(v) for v in sys.stdin.readline().split()]

g = Tree()
for i in range(0,n-1):
	g.add_child(h[i], i+1)
	# g.addEdge(i+1, h[i])
	
g.DFS(Node(None, 0))
print("guards provided: #{}, needed: #{}".format(k, len(g.get_guards())))
if k < len(g.get_guards()):
	print("ATTACK")
else:
	print("DEFEND")