import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.StringTokenizer;


/**
 * ICPC - CERC 2020
 * Sample Solution: Alabama
 * 
 * @author Josef Cibulka
 */
public class alabama {
  StringTokenizer st = new StringTokenizer("");
  BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
  boolean hasNextToken() {
    try {
      while (!st.hasMoreTokens()) {
        String line = input.readLine();
        if (line == null) return false;
        st = new StringTokenizer(line);
      }
    } catch (IOException ex) { throw new RuntimeException(ex); }
    return true;
  }
  String nextToken() {
    return (!hasNextToken()) ? null : st.nextToken();
  }
  int nextInt() {
    return Integer.parseInt(nextToken());
  }
  public static void main(String[] args) {
    new alabama().run();
  }
  
  int[] id2Coord(int n, int id) {
    int[] ret = new int[n];
    int i = 0;
    while (id > 0) {
      ret[i++] = id % 3;
      id /= 3;
    }
    return ret;
  }

  int coord2Id(int n, int[] coord) {
    int ret = 0;
    for (int i=n-1; i>=0; --i) {
      ret = 3*ret + coord[i];
    }
    return ret;
  }
  
  // Coordinate-wise sum id1 + 2*id2 mod 3.
  int combine(int n, int id1, int id2) {
    int[] c1 = id2Coord(n, id1), c2 = id2Coord(n, id2);
    int[] ret = new int[n];
    for (int i=0; i<n; ++i) {
      ret[i] = (c1[i] + 2 * c2[i]) % 3;
    }
    return coord2Id(n, ret);
  }

  int getEdge(int n, int[][] e, int id1, int id2) {
    int[] c1 = id2Coord (n, id1);
    int[] c2 = id2Coord (n, id2);
    int ret = 0;
    for (int i=0; i<n; ++i) {
      for (int j=0; j<n; ++j) {
        ret += c1[i]*e[i][j]*c2[j];
      }
    }
    return ret % 3;
  }
  
  // Simple O(n^2+m) implementation of Dijkstra. Could be made faster by
  // reducing the graph to only vertices with idCnt > 0.
  int[] dij(int maxv,int[][] eId, int[] idCnt, int t1, int t2) {
    int[] dst = new int[maxv];
    boolean[] vis = new boolean[maxv];
    // Start from the vertex with id 1 that is not counted in idCnt[1].
    for (int i=0; i<maxv; ++i) {
      int ed = eId[1][i];
      if (idCnt[i] > 0 && ed != 0)
        dst[i] = (ed == 1 ? t1 : t2);
      else
        dst[i] = -1;
    }
    while (true) {
      int best = -1;
      for (int i=0; i<maxv; ++i) {
        if (vis[i] || idCnt[i] == 0 || dst[i] == -1)
          continue;
        if (best == -1 || dst[i] < dst[best])
          best = i;
      }
      if (best == -1)
        break;
      for (int i=0; i<maxv; ++i) {
        int ed = eId[best][i];
        if (idCnt[i] == 0 || ed == 0)
          continue;
        int newDst = dst[best] + (ed == 1 ? t1 : t2);
        if (dst[i] == -1 || newDst < dst[i])
          dst[i] = newDst;
      }
      vis[best] = true;
    }
    return dst;
  }

  void run() {
    int n = nextInt(), m = nextInt(), r = nextInt(), t1 = nextInt(), t2 = nextInt();;
    int maxv = 1;
    for (int i=0; i<n; ++i) {
      maxv *= 3;
    }
    int[][] e = new int[n][n];
    for (int i=0; i<m; ++i) {
      int tmp1 = nextInt(), tmp2 = nextInt();
      String t = nextToken();
      int tmp3 = (t.equals("O") ? 1 : 2);
      e[tmp1][tmp2] = e[tmp2][tmp1] = tmp3;
    }
    
    int[] cnts = new int[maxv];
    int[] ids = new int[n+r];
    int[] idCnt = new int[maxv];
    for (int i=0; i<n; ++i) {
      int[] coord = new int[n];
      coord[i] = 1;
      ids[i] = coord2Id(n, coord);
      idCnt[ids[i]]++;
    }
    // Do not count the starting vertex - it's distance is 0, but other vertices
    // with id=1 have nonzero distance.
    --idCnt[1];
    
    int[][] eId = new int[maxv][maxv];
    for (int i=0; i<maxv; ++i)
      for (int j=0; j<maxv; ++j) {
        eId[i][j] = getEdge(n, e, i, j);
      }
    
    int[] dijDst = new int[maxv];
    for (int i=n; i<n+r; ++i) {
      int tmp1 = nextInt(), tmp2 = nextInt();
      int id1 = ids[tmp1], id2 = ids[tmp2];
      ids[i] = combine(n, id1, id2);
      idCnt[ids[i]]++;
      if(idCnt[ids[i]] <= 1) {
        dijDst = dij(maxv, eId, idCnt, t1, t2);
      }
      int res = 0;
      for (int j=0; j<maxv; ++j)
        if (dijDst[j] >= 0)
          res += idCnt[j] * dijDst[j];
      System.out.println(res);
    }
  }
}
