import fileinput
import sys
sys.setrecursionlimit(6666)

a = list(fileinput.input())[1:]
margin = 5
a = [i.strip('\n') for i in a]

m = len(a[0])
for i in range(margin):
  a.insert(0, "X"*(m))
  a.append("X"*(m))

n = len(a)
for i in range(n):
  for j in range(margin):
    a[i] = "X" + a[i] + "X"

m = len(a[0])

objects = ['*', '^', '!', '/', '\\', 'v', 'D', 'G']
ptaci = ['v', 'D']

counts = dict()
for i in range(n):
  for j in range(m):
    if not a[i][j] in objects:
      continue
  
    if a[i][j] not in counts: counts[a[i][j]] = 0
    counts[a[i][j]] += 1



king = [(i, j) for i in range(-1, 2) for j in range(-1, 2)]
king.remove((0,0))
ortho = [(1, 0), (-1, 0), (0, 1), (0, -1)]
hn = [[0 for i in range(m)] for j in range(n)]


knight = []
for i in range(-2, 3):
  for j in range(-2, 3):
    if i*i + j*j == 2*2 + 1:
      knight += [(i, j)]

def hejnaDfs(a, i, j, num):
  global ortho, hn
  if a[i][j] != 'v' and a[i][j] != 'D': return
  if a[i][j] == 'X': return
  if hn[i][j] != 0: return
  hn[i][j] = num
  for mv in ortho: hejnaDfs(a, i+mv[0], j+mv[1], num)
  
cnt = 0
for i in range(n):
  for j in range(m):
    if hn[i][j] == 0 and a[i][j] in ptaci:
      cnt += 1
      hejnaDfs(a, i, j, cnt)

def slunickoPaint(a, mask, si, sj, di, dj):
  si += di
  sj += dj
  mask[si][sj] = 1
  while (a[si][sj] == ' '):
    si += di
    sj += dj
    mask[si][sj] = 1



### 1.
def slunicka(n, m, a):
  mask = [[0 for i in range(m)] for j in range(n)]
  for i in range(n):
    for j in range(m):
      if a[i][j] == '*':
        for mv in king:
          slunickoPaint(a, mask, i, j, mv[0], mv[1])

  res = 0
  for i in range(n):
    for j in range(m):
      res += ((a[i][j] in objects and a[i][j] != '*') * mask[i][j])

  return res*100

### 2.
def nejvetsiPtak(n, m, a):
  global hn, cnt
  res = 0
  for h in range(1, cnt+1):
    mx = 0
    for i in range(n):
      cur = 0
      for j in range(m):
        if hn[i][j] == h:
          cur += 1
          mx = max(mx, cur)
        else:
          cur = 0
    res += mx
  return res*500

### 3.
def obvodHejna(n, m, a):
  global king, ptaci, ortho
  res = 0
  for i in range(n):
    for j in range(m):
      if a[i][j] in ptaci:
        for mv in ortho:
          nb = a[i+mv[0]][j+mv[1]]
          res += (nb not in ptaci)
  return res*60

### 4.
def dfsDomecky(i, j, a, maxy, miny, vis, start):
  if (i, j) in vis: return set()
  if (i > maxy or i < miny) and not start: return set()
  if a[i][j] != ' ' and not start: return set()

  vis.add((i, j))
  if start:
    res = set()
  else:
    res = set({(i,j)})
  for mv in ortho:
    res |= dfsDomecky(i+mv[0], j+mv[1], a, maxy, miny, vis, False)
  return res

def domecky(n, m, a):
  res = 0
  for i in range(n):
    for j in range(m):
      if a[i][j] == '^':
        ci = i-1
        while a[ci][j] == ' ':
          res += 1
          ci -= 1

  return res*10

### 5.
def tritriBloky(n, m, a):
  global margin
  un = set()
  blok = [(i, j) for i in range(3) for j in range(3)]
  for i in range(margin, n-2-margin):
    for j in range(margin, m-2-margin):
      un.add(tuple([a[i + b[0]][j + b[1]] for b in blok]))
  return len(un)


### 6.
def zivocichove(n, m, a):
  global ortho
  res = 0
  for i in range(n):
    for j in range(m):
      if a[i][j] == '!' or a[i][j] == 'v' or a[i][j] == 'D':
        for mv in ortho:
          res += (a[i+mv[0]][j+mv[1]] == ' ')
  return res*15

### 7.
def volDfs(i, j, a, vis, start):
  if a[i][j] == 'X':
    return True
  if (i, j) in vis or (a[i][j] != ' ' and not start):
    return False

  vis.add((i,j))
  res = False
  for mv in ortho:
    res |= volDfs(i+mv[0], j+mv[1], a, vis, False)
  return res

def volnost(n, m, a):
  global objects
  res = 0
  for i in range(n):
    for j in range(m):
      if a[i][j] in objects: 
        res += volDfs(i, j, a, set(), True)
  return res*7

### 8.
def chupacabra(n, m, a):
  global knight, ptaci
  res = 0
  for i in range(n):
    for j in range(m):
      if a[i][j] in ptaci:
        has = False
        for mv in knight:
          if a[i+mv[0]][j+mv[1]] == '!':
            has = True
        res += has
  return res*200

### 9.
def vrcholky(n, m, a):
  res = 0
  for i in range(n):
    for j in range(m-1):
      if a[i][j] == '/' and a[i][j+1] == '\\':
        cur = 0
        for k in range(n):
          for l in range(m-1):
            if a[k][l] == '/' and a[k][l+1] == '\\':
              cur = max(cur, abs(k-i) + abs(j-l))
        res += cur
  return res*50

### 10.
def dckGrill(n, m, a):
  res = 0
  for i in range(n):
    for j in range(m):
      if a[i][j] == 'D':
        for mv in ortho:
          if a[i+mv[0]][j+mv[1]] == 'G':
            res += 1
            break
  return res*500

### 11.
def frekvence(n, m, a):
  global objects, counts
  res = 0
  for i in counts.values():
    if i == min(counts.values()):
      res += i
  return res*10

### 12.
def prazdnaPolicka(n, m, a):
  res = 0
  for i in range(n):
    for j in range(m):
      res += a[i][j] == ' '
  return res


### 13.
def zver(n, m, a):
  global objects
  cnts = dict()
  for o in objects: cnts[o] = 0
  for i in range(n):
    for j in range(m):
      if a[i][j] in objects:
        cnts[a[i][j]] += 1
  return cnts['!'] * cnts['v'] * cnts['D']


### 14.
#def podomecky(n, m, a):
  #res = set()
  #for i in range(n):
    #for j in range(m):
      #if a[i][j] == '^':
        #res |= dfsDomecky(i, j, a, 1000, i+1, set(), True)
  #return len(res)*5
def podomecky(n, m, a):
  return domecky(n, m, a)//2


### 15.
def grillDck(n, m, a):
  res = 0
  for i in range(n):
    for j in range(m):
      if a[i][j] == 'G':
        for mv in ortho:
          if a[i+mv[0]][j+mv[1]] == 'D':
            res += 1
            break
  return res*50


### 16.
def domeckySGrilem(n, m, a):
  global counts
  if '^' in counts and 'G' in counts:
    return 3*min(counts['^'], counts['G'])
  else:
    return 0

fns = [slunicka, nejvetsiPtak, obvodHejna, domecky, tritriBloky, zivocichove, volnost, chupacabra, vrcholky, dckGrill, frekvence, prazdnaPolicka, zver, podomecky, grillDck, domeckySGrilem]
result = 0

for fn in fns:
  print("Pravidlo", 1+fns.index(fn), fn, file=sys.stderr)
  ruleRes = fn(n, m, a)
  result += ruleRes
  print(ruleRes, file=sys.stderr)

print(result)
