import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;


/**
 * ICPC - CTU Open Contest 2019
 * Sample Solution: Musicians on a Tour
 * 
 * @author Martin Kacer
 */
public class Musicians {
	StringTokenizer st = new StringTokenizer("");
	BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
	boolean hasNextToken() {
		try {
			while (!st.hasMoreTokens()) {
				String line = input.readLine();
				if (line == null) return false;
				st = new StringTokenizer(line);
			}
		} catch (IOException ex) { throw new RuntimeException(ex); }
		return true;
	}
	String nextToken() {
		return (!hasNextToken()) ? null : st.nextToken();
	}
	int nextInt() {
		return Integer.parseInt(nextToken());
	}
	public static void main(String[] args) {
		new Musicians().run();
	}
	
	static class Code {
		final int code;
		Code(int c) { code = c; }
	}
	
	Set<Code> avail = new HashSet<>();
	
	void run() {
		int n = nextInt(), k = nextInt();
		while (n-- > 0) avail.add(new Code(nextInt()));
		int res = 0;
		for (int b = 1<<30; b > 0; b>>=1) {
			final int bb = b;
			int cnt = 0;
			for (Code c : avail) if ((c.code & bb) != 0) ++cnt;
			if (cnt >= k) {
				avail.removeIf(c -> (c.code & bb) == 0);
				res |= bb;
			}
		}
		System.out.println(res);
	}
}
