import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.StringTokenizer;


/**
 * ICPC - CTU Open Contest 2019
 * Sample Solution: XXX
 * 
 * @author Martin Kacer
 */
public class DivisorsSum {
	StringTokenizer st = new StringTokenizer("");
	BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
	boolean hasNextToken() {
		try {
			while (!st.hasMoreTokens()) {
				String line = input.readLine();
				if (line == null) return false;
				st = new StringTokenizer(line);
			}
		} catch (IOException ex) { throw new RuntimeException(ex); }
		return true;
	}
	String nextToken() {
		return (!hasNextToken()) ? null : st.nextToken();
	}
	long nextLong() {
		return Long.parseLong(nextToken());
	}
	public static void main(String[] args) {
		new DivisorsSum().run();
	}
	
	BigInteger divSum(long max) {
		BigInteger sum = BigInteger.ZERO;
		long d;
		for (d = 1; d*d <= max; ++d)
			sum = sum.add(BigInteger.valueOf(max / d));
		for (long c = --d; c >= 1; --c) {
			long t = max/c;
			sum = sum.add(BigInteger.valueOf(c * (t - d)));
			d = t;
		}
		return sum;
	}
	
	void run() {
		long a = nextLong(), b = nextLong();
		System.out.println(divSum(b).subtract(divSum(a-1)));
	}
}
