import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;


/**
 * ICPC - CERC 2019
 * Sample Solution: Chocolate
 * 
 * @author Martin Kacer
 */
public class Chocolate {
	StringTokenizer st = new StringTokenizer("");
	BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
	boolean hasNextToken() {
		try {
			while (!st.hasMoreTokens()) {
				String line = input.readLine();
				if (line == null) return false;
				st = new StringTokenizer(line);
			}
		} catch (IOException ex) { throw new RuntimeException(ex); }
		return true;
	}
	String nextToken() {
		return (!hasNextToken()) ? null : st.nextToken();
	}
	int nextInt() {
		return Integer.parseInt(nextToken());
	}
	public static void main(String[] args) {
		new Chocolate().run();
	}
	
	Map<String,Integer> dirs = new HashMap<>();
	
	void run() {
		int r = nextInt(), c = nextInt(), k = nextInt(), rtop = r, rbot = 0, clef = c, crig = 0;
		for (int i = 0; i < k; ++i) {
			int r0 = nextInt(), c0 = nextInt();
			rtop = Math.min(rtop, r0-1); rbot = Math.max(rbot, r0);
			clef = Math.min(clef, c0-1); crig = Math.max(crig, c0);
		}
		dirs.put("top", rtop); dirs.put("bottom", r-rbot);
		dirs.put("left", clef); dirs.put("right", c-crig);
		for (;;) {
			play();
			System.out.flush();
			String dir = nextToken();
			if (dir.charAt(0) == 'y') return;
			int cnt = nextInt();
			makeMove(dir, cnt, false);
		}
	}
	
	void makeMove(String dir, int cnt, boolean print) {
		dirs.put(dir, dirs.get(dir) - cnt);
		if (print)
			System.out.println(dir + " " + cnt);
	}
	
	void play() {
		int x = 0;
		for (int v : dirs.values()) x ^= v;
		if (x == 0) { System.out.println("pass"); return; }
		for (Map.Entry<String,Integer> me : dirs.entrySet()) {
			int leave = me.getValue() ^ x;
			if (leave < me.getValue()) {
				makeMove(me.getKey(), me.getValue() - leave, true);
				return;
			}
		}
	}
}
