#include <bits/stdc++.h>
using namespace std;
typedef long long int ll;
typedef double ld;
typedef vector<ll> vi;
// push_back insert lower_bound upper_bound erase

#define F(a) for ( ll i = 0; i < (ll)(a); ++i )

// 1e-12 is too low
#define EPS (1e-10)
//bool eq(ld a, ld b) { return fabs(a-b) <= fabs(a+b) * EPS; } // cannot compare very small numbers to each other
bool eq(ld a, ld b) { return abs(a-b) <= EPS; }
int dcmp(ld x){ return (fabs(x)<EPS) ? 0 : (x<0 ? -1 : 1); }

struct Pt{
    ld x, y;
    ll flag;
    bool operator <(const Pt &p) const {
        return x < p.x-EPS || (eq(x, p.x) && y < p.y-EPS);
    }
    Pt operator+(const Pt &p){ return{x+p.x, y+p.y}; }
    Pt operator-(const Pt &p){ return{x-p.x, y-p.y}; }
    Pt operator-(){ return{-x, -y}; }
    Pt operator*(ld d){ return {x*d, y*d}; }
    Pt operator/(ld d){ return {x/d, y/d}; }
    friend ostream &operator<<(ostream &os, const Pt &a){ os<<a.x<<' '<<a.y; return os; }
    friend istream &operator>>(istream &is, Pt &a){ is>>a.x>>a.y; return is; }
};
struct Line {
    Pt a, b;
    ll side; // 0=east-west, 1=north-south, 2=outside the roof
    bool operator<(Line &l){
        Pt v=b-a, w=l.b-l.a;
        return atan2(v.y, v.x) < atan2(w.y, w.x);
    }
};
ld vec(Pt a, Pt b){ return a.x*b.y-a.y*b.x; }
ld vec(Pt a, Pt b, Pt c){ return vec(b-a, c-a); }
ld dot(Pt a, Pt b){ return a.x*b.x+a.y*b.y; }
ld norm(Pt a){ return hypot(a.x, a.y); }
ld line_point_dist(Line l, Pt p){ return fabs(vec(p-l.a, l.b-l.a)/norm(l.b-l.a)); }
Pt scale_to(Pt a, ld res){ return a*res/norm(a); }
Pt normal(Pt a){ ld n=norm(a); return {-a.y/n, a.x/n}; }
ld angle2(Pt a, Pt b){
    a=scale_to(a, 1);
    b=scale_to(b, 1);
    ld ang=acos(dot(a, b));
    //ld ang=acos(dot(a, b)/norm(a)/norm(b));
    if(ang>M_PI)ang-=2*M_PI;
    return ang;
}
ld angle(Pt a, Pt b){
    ld ang=atan2(vec(a,b),dot(a,b));
    if(ang>M_PI)ang-=2*M_PI;
    if(ang<-M_PI)ang+=2*M_PI;
    return ang;
}
Pt lines_intersection(Line p, Line q){
    Pt v=p.b-p.a;
    Pt w=q.b-q.a;
    ld t=vec(w, p.a-q.a)/vec(v, w);
    return p.a+v*t;
}
Pt line_point_closest_point(Line a, Pt b){
    return lines_intersection(a, {b, b+normal(a.b-a.a)});
}
bool is_point_on_segment(Pt p, Line s){
    return dcmp(vec(s.a-p, s.b-p))==0 && dcmp(dot(s.a-p, s.b-p))<=0;
}
bool is_point_in_polygon_clock(Pt p, vector<Line> &lines){
    for(Line &l:lines)if(is_point_on_segment(p, l))return true;
    ld sum = 0;
    for(Line &l:lines){
        ld ang=angle(l.a-p, l.b-p);
        //cerr<<"angle: "<<ang<<endl;
        sum += ang;
    }
    //cerr<<"sum: "<<sum<<", eq to 0: "<<eq(sum,0)<<endl;
    return !eq(sum, 0);
}

int is_point_in_polygon(Pt p, vector<Line> &lines){
    ll n=lines.size(), wn=0;
    for(int i=0; i<n; ++i){
        Pt &p1 = lines[i].a;
        Pt &p2 = lines[i].b;
        if(is_point_on_segment(p, lines[i])) return 1;//point on the border
        int k = dcmp(vec(p2-p1, p-p1));
        int d1 = dcmp(p1.y-p.y);
        int d2 = dcmp(p2.y-p.y);
        if(k>0 && d1<=0 && d2>0) wn++;
        if(k<0 && d2<=0 && d1>0) wn--;
    }
    return wn;// wn=1 point is inside, 0 outisde
}
bool point_is_inside2(Pt p, vector<Line> &poly){
    for(Line &l:poly)if(is_point_on_segment(p, l))return true;
    ll r=0;
    p.x += EPS/2;
    p.y += EPS/2;
    for(int i=0; i<4; ++i){
        ll cnt = 0;
        for(Line &l:poly){
            if(p.y < l.a.y)
                if(l.a.x < p.x+EPS && p.x < l.b.x || l.b.x < p.x+EPS && p.x < l.a.x)
                    cnt+=1;
        }
        if((cnt%2) == 0) r++;
        swap(p.x,p.y);
        p.y=-p.y;
    }
    return r<4;
}
bool point_is_inside(Pt p, vector<Line> &poly){
    vector<bool> res;
    //res.push_back(point_is_inside2(p, poly));
    //res.push_back(is_point_in_polygon(p, poly));
    res.push_back(is_point_in_polygon_clock(p, poly));
    assert(res.size());
    //cerr<<"inside?: "; F(res.size())cerr<<res[i]<<' '; cerr<<endl;
    F(res.size()-1){
        if(res[i]!=res[i+1]){
            cerr<<"point is inside results: "; for(ll n:res)cerr<<n<<' '; cerr<<endl;
            cerr<<"and polygon:";for(Line l:poly)cerr<<" ["<<l.a<<"]"; cerr<<endl;
            cerr<<fixed<<setprecision(12);
            cerr<<"for point ["<<p<<"]\n";
            cerr<<endl;
            //cerr<<is_point_in_polygon_clock(p, poly)<<endl;
            assert(res[i]==res[i+1]);
        }
    }
    return res[0];
}


ll N, M;
Line l;
ld line_length, line_ang;
vector<Pt> a;
vector<Line> lines;
void load(){
    cin>>N;
    cin>>l.a>>l.b;
    Pt d=l.b-l.a;
    a.assign(N, {});
    F(N) cin>>a[i];
    lines.assign(N, {});
    F(N) lines[i]={a[i], a[(i+1)%N]};
    F(N) lines[i].side=lines[i].a.y==lines[i].b.y;
}

Pt point_from_ratio(ld ratio){
    return l.a*(1-ratio)+l.b*ratio;
}

pair<ll,ld> find_closest_side(ld ratio){
    Pt center = point_from_ratio(ratio);
    ld dist=1e60;
    ll id=-1;
    bool inside = point_is_inside(center, lines);
    F(N){
        Pt d1=center-lines[i].a;
        Pt d2=center-lines[i].b;
        ld d=dist;
        if(!inside || vec(lines[i].a, lines[i].b, center)>=-EPS){
            if(d1.x==d2.x && (d1.y*d2.y<0 || min(abs(d1.y),abs(d2.y)) <= abs(d1.x))) { d=min(d, abs(d1.x)); }
            if(d1.y==d2.y && (d1.x*d2.x<0 || min(abs(d1.x),abs(d2.x)) <= abs(d1.y))) { d=min(d, abs(d1.y)); }
        }
        //cerr<<"point "<<center<<" is "<<d<<" close to "<<i<<endl;
        if(d<dist-EPS){ // strictly prefer the first found
            dist=d;
            id=i;
        }
    }
    assert(id!=-1);
    //if(ratio<0.1){
        //cerr<<"closest to "<<id<<"  --  ["<<center<<"] in:"<<inside<<' '<<", dist: "<<dist<<endl;
    //}
    //cerr<<"closest side to "<<center<<" is "<<id<<endl;
    return {inside?id:(-1-id), dist};
}
pair<ld,ll> bsearch(ld low, ld high, ll low_edge_id){
    ld mid;
    //cerr<<setprecision(16);
    const ld max_step=0.5;
    while(low < high-EPS){
        mid = (low+high)/2;
        ld step_size = line_length*(mid-low);
        if(step_size > max_step){ // the biggest allowed step
            mid = low+max_step/line_length;
        }
        //cerr<<line_length<<' '<<low<<' '<<mid<<' '<<high<<endl;
        ll closest_eid = find_closest_side(mid).first;
        //cerr<<"FIND: "<<mid<<" -> "<<closest_eid<<" vs "<<low_edge_id<<" : "<<(closest_eid!=low_edge_id)<<endl;
        if(closest_eid != low_edge_id) high = mid;
        else low = mid+EPS;
    }
    return {high, find_closest_side(high).first};
}
// first double point which has a different id from the previous side
//bool cmp(ld d, ll low_edge_id){
    //ll closest_edge_id = find_closest_side(d).first;
    //return closest_edge_id!=low_edge_id;
//}

struct Res{
    ld ratio;
    ll eid, state;
    Pt point;

    Res(ld ratio, ll eid):ratio(ratio),eid(eid){
        point = point_from_ratio(ratio+EPS);
        eid=find_closest_side(ratio).first;
        state = (eid<0) ? state = 2 : lines[eid].side; // outside is 2
    }
};

int main(){
    load();
    Pt ldif=l.b-l.a;
    line_length=hypot(ldif.x, ldif.y);
    line_ang=atan2(ldif.y, ldif.x);
    ll first=find_closest_side(0.0).first;
    ll last=find_closest_side(1.0).first;
    if(first<0){ cerr<<"FIRST: "<<first<<endl; }
    assert(first>=0);
    if(last<0){ cerr<<"LAST: "<<last<<endl; }
    assert(last>=0);
    vector<Res> path;
    path.push_back({0.0, first});
    ll current_eid=first;
    ld current_ratio=0.0;
    //cout<<"0\n";return 0;
    while(current_ratio < 1.-EPS){
        //cerr<<current_eid<<endl;
        pair<ld,ll> p=bsearch(current_ratio, 1.0, current_eid);
        ld new_ratio = p.first;
        //cerr<<"find_closest_side\n";
        ll new_eid = p.second;
        path.push_back({new_ratio, new_eid});
        //cerr<<"current ratio: "<<current_ratio<<", "<<new_ratio<<endl;
        //cerr<<"current eid: "<<current_eid<<", "<<new_eid<<endl;
        current_ratio = new_ratio;
        current_eid = new_eid;
    }
    path.push_back({1.0, last});
    ld side_sum[3]; side_sum[0]=side_sum[1]=side_sum[2]=0; // north-south, east-west, outside
    F(path.size()-1){
        ld dif=path[i+1].ratio-path[i].ratio;
        ld eid=path[i].eid;
        ld ratio=path[i].ratio;
        Pt center = l.a*(1-ratio)+l.b*ratio;
        ll side=path[i].state;
        assert(side >= 0 && side <= 2);
        side_sum[side]+=dif;
    }
    ld sum=side_sum[0]*(hypot(1, abs(cos(line_ang))))+side_sum[1]*(hypot(1, abs(sin(line_ang))))+side_sum[2];
    ld res=sum*hypot(ldif.x, ldif.y);
    cout<<fixed<<setprecision(12);
    cout<<res<<endl;

    // only for drawing testcases visual correctness check:
    cout<<fixed<<setprecision(6);
    for(auto p:path){
        Pt r=p.point;
        auto pr=find_closest_side(p.ratio);
        bool inside = point_is_inside(r, lines);
        ll id = pr.first;
        ld dist = pr.second;
        cout<<r<<' '<<max(0.1,dist)<<' '<<(inside ? lines[id].side : -1)<<endl;
    }
    return 0;
}

