#include <bits/stdc++.h>
#define ff first
#define ss second
#define F(i,a,b) for ( int i = (int)(a); i < (int)(b); ++i )
#define PB push_back
using namespace std;
using ii = pair<int,int>;
using vi = vector<int>;
using ll = long long;

const ii N_range = { 1, 1e9 };
const ii Q_range = { 1, 100 };
const int INF = 1e9+7;

template <typename Number>
using Matrix = vector<vector<Number>>;

template <typename Number>
Matrix<Number> multiply(const Matrix<Number> & a, const Matrix<Number> & b, ll mod = 0) {
    assert(a[0].size() == b.size());
    auto c = Matrix<Number>( a.size(), vector<Number>( b[0].size(), 0 ) );
    F(i,0,a.size()) {
        F(j,0,b[0].size()) {
            F(k,0,b.size()) {
                c[i][j] = (c[i][j] + a[i][k] * b[k][j]);
                if (mod)
                    c[i][j] %= mod;
            }
        }
    }
    return c;
}

template <typename Number>
Matrix<Number> modpow(Matrix<Number> b, ll e, ll m) {
    Matrix<Number> elem = b;
    for (auto & row : elem)
        for (auto & col : row)
                col = 0;
    F(i,0,min(elem.size(), elem[0].size()))
        elem[i][i] = 1;
    if (!e)
        return elem;
    while (e) {
        if (e & 1)
            elem = multiply(elem, b, m);
        b = multiply(b, b, m);
        e /= 2;
    }
    return elem;
}

struct AhoCorasick {
    struct Vertex {
        map<char, int> children;            // Links to the child vertexes in the trie:
        bool active = true;  // If word should be found
        bool leaf = false; // Flag that some word from the dictionary ends in this vertex
        char parentChar;          // Char which moves us from the parent vertex to the current vertex
        int parent = -1;    // Link to the parent vertex
        int suffixLink = -1;    // Suffix link from current vertex (the equivalent of P[i] from the KMP algorithm)
        int wordId = -1;    // If the vertex is the leaf, we store the ID of the word
        int endWordLink = -1;    // Link to the leaf vertex of the maximum-length word we can make from the current prefix
    };

    vector<Vertex> trie = {{}};
    vector<string> words;
    const int root = 0;

    AhoCorasick(const vector<string> &words) : words(words) {
        for (size_t i = 0; i < words.size(); ++i)
            AddString(words[i], i);
        CreateAhoCorasick();
    }

    void AddString(const string &s, int wordId) {
        int curVertex = root;
        for (char c : s) {
            if (!trie[curVertex].children.count(c)) {
                trie.push_back({});
                trie.back().parent = curVertex;
                trie.back().parentChar = c;
                trie[curVertex].children[c] = trie.size() - 1;
            }
            curVertex = trie[curVertex].children[c]; // Move to the new vertex in the trie
        }
        // Mark the end of the word and store its ID
        trie[curVertex].leaf = true;
        trie[curVertex].wordId = wordId;
    }

    void CreateAhoCorasick() {
        queue<int> vertexQueue;
        vertexQueue.push(root);
        while (!vertexQueue.empty()) {
            int curVertex = vertexQueue.front();
            vertexQueue.pop();
            CalcSuffLink(curVertex);

            for (auto x : trie[curVertex].children)
                vertexQueue.push(x.second);
        }
    }

    void CalcSuffLink(int vertexId) {
        Vertex &vertex = trie[vertexId];
        // Processing root (empty string)
        if (vertexId == root) {
            vertex.suffixLink = root;
            vertex.endWordLink = root;
            return;
        }
        // Processing children of the root (one character substrings)
        if (vertex.parent == root) {
            vertex.suffixLink = root;
            vertex.endWordLink = vertex.leaf ? vertexId : trie[vertex.suffixLink].endWordLink;
            return;
        }
        // Cases above are degenerate cases as for prefix function calculation; the
        // value is always 0 and links to the root vertex.

        // To calculate the suffix link for the current vertex, we need the suffix
        // link for the parent of the vertex and the character that moved us to the
        // current vertex.
        int curBetterVertex = trie[vertex.parent].suffixLink;
        char chVertex = vertex.parentChar;
        // From this vertex and its substring we will start to look for the maximum
        // prefix for the current vertex and its substring.

        while (true) {
            // If there is an edge with the needed char, we update our suffix link
            // and leave the cycle
            if (trie[curBetterVertex].children.count(chVertex)) {
                vertex.suffixLink = trie[curBetterVertex].children[chVertex];
                break;
            }
            // Otherwise, we are jumping by suffix links until we reach the root
            // (equivalent of k == 0 in prefix function calculation) or we find a
            // better prefix for the current substring.
            if (curBetterVertex == root) {
                vertex.suffixLink = root;
                break;
            }
            curBetterVertex = trie[curBetterVertex].suffixLink; // Go back by sufflink
        }
        // When we complete the calculation of the suffix link for the current
        // vertex, we should update the link to the end of the maximum length word
        // that can be produced from the current substring.
        vertex.endWordLink = vertex.leaf ? vertexId : trie[vertex.suffixLink].endWordLink;
    }

    int solve(int N) {
        Matrix<long> X(trie.size(), vector<long>(trie.size(), 0)), P(trie.size(), vector<long>(1));
        P[0][0] = 1;
        for (int s = 0; s < (int)trie.size(); ++s) {
            if (trie[s].leaf)
                continue;
            for (char c = 'a'; c <= 'z'; ++c) {
                int currentState = s;
                while (true) {
                    if (trie[currentState].children.count(c)) {
                        currentState = trie[currentState].children[c];
                        break;
                    }
                    if (currentState == root)
                        break;
                    currentState = trie[currentState].suffixLink;
                }
                if (!trie[currentState].leaf)
                    X[currentState][s]++;
            }
        }
        X = modpow(X, N, INF);
        P = multiply(X, P);
        int res = 0;
        for (int s = 0; s < (int)trie.size(); ++s)
            res = (res + P.at(s).at(0)) % INF;
        return res;
    }
};


ll modpow(ll b, ll e, ll m) {
        b %= m;
        ll r = 1;
        while (e > 0) {
            if (e & 1)
                r = (r * b) % m;
            b = (b * b) % m;
            e >>= 1;
        }
        return r;
    }

int main() {
    ios::sync_with_stdio(0);
    int n, qq;
    assert(cin >> n && "Could not read N");
    assert(N_range.ff <= n && n <= N_range.ss && "Invalid value of N");
    assert(cin >> qq && "Could not read Q");
    assert(Q_range.ff <= qq && qq <= Q_range.ss && "Invalid value of Q");
    vector<string> forbidden(qq);
    for (int i = 0, lenSum = 0; i < qq; ++i) {
        int len;
        assert(cin >> len && "Could not read len");
        assert(cin >> forbidden[i] && "Could not read forbidden phrase");
        assert(len == (int)forbidden[i].size() && "Size mismatch of forbidden");
        lenSum += forbidden[i].size();
        assert(lenSum <= Q_range.ss && "Too long forbidden phrases");
    }
    assert(cin.get() == '\n' && cin.get() == EOF && "Garbage after forbidden phrases");

    AhoCorasick ac(forbidden);
    cout << ac.solve(n) << endl;
    return 0;
}
