import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;


/**
 * ICPC - CTU Open Contest 2019
 * Sample Solution: Acceptable Tunes
 * 
 * @author Martin Kacer
 */
public class AcceptableTunes {
	StringTokenizer st = new StringTokenizer("");
	BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
	boolean hasNextToken() {
		try {
			while (!st.hasMoreTokens()) {
				String line = input.readLine();
				if (line == null) return false;
				st = new StringTokenizer(line);
			}
		} catch (IOException ex) { throw new RuntimeException(ex); }
		return true;
	}
	String nextToken() {
		return (!hasNextToken()) ? null : st.nextToken();
	}
	int nextInt() {
		return Integer.parseInt(nextToken());
	}
	public static void main(String[] args) {
		new AcceptableTunes().run();
	}
	
	static final int MOD = 1_000_000_007, MAXST = 120;
	
	void run() {
		int n = nextInt(), q = nextInt();
		int stcnt = 0;
		boolean stfin[] = new boolean[MAXST];

		Map<String,Integer> prf = new HashMap<>();
		while (q-- > 0) {
			String w = nextToken(); w = nextToken();
			for (int i = 0; i <= w.length(); ++i) {
				String pk = w.substring(0, i);
				if (!prf.containsKey(pk))
					prf.put(pk, stcnt++);
			}
			stfin[prf.get(w)] = true;
		}
		int[][] trans = new int[stcnt][stcnt];
		for (Map.Entry<String, Integer> me : prf.entrySet()) {
			int i = me.getValue();
			for (int c = 0; c < 26; ++c)
				if (stfin[i])
					++trans[i][i];
				else {
					int p = 0;
					for (int j = me.getKey().length(); j >= 0; --j)
						p = prf.getOrDefault(me.getKey().substring(j) + (char)(c+'a'), p);
					++trans[i][p];
				}
		}		
		trans = pow(stcnt, trans, n);
		int sum = 0;
		for (int i = 0; i < stcnt; ++i)
			if (!stfin[i])
				sum = (sum + trans[0][i]) % MOD;
		System.out.println(sum);
	}
	
	int[][] pow(int n, int[][] a, long k) {
		int[][] res = new int[n][n];
		for (int i = 0; i < n; ++i) res[i][i] = 1;
		for (; k > 0; k >>= 1) {
			if ((k & 1) == 1) res = mul(n, res, a);
			a = mul(n, a, a);
		}
		return res;
	}
	
	int[][] mul(int n, int[][] a, int[][] b) {
		int[][] res = new int[n][n];
		for (int i = 0; i < n; ++i)
			for (int j = 0; j < n; ++j)
				for (int k = 0; k < n; ++k)
					res[i][j] = (int) ((res[i][j] + (long) a[i][k] * b[k][j]) % MOD);
		return res;
	}
}
