#!/usr/bin/env python3
import fileinput
import math
import sys

def computeD(A, B, C):
    return B**2 - 4 * A * C

def intersecty(a, b, R, a1, a2):
    k = a / b
    A = k**2 + 1
    B = -2 * ((a1 * k) + a2)
    C = a1**2 + a2**2 - R**2
    D = computeD(A,B,C)
    if D < 0:
        return None
    # x =a * y/b
    odmD = math.sqrt(D)
    y1 = (-B + odmD)/(2*A)
    x1 = k * y1
    y2 = (-B - odmD)/(2*A)
    x2 = k * y2
    if y1/b > y2/b:
        return ((y1/b, x1, y1, 'R'), (y2/b, x2, y2, 'L'))
    else:
        return ((y1/b, x1, y1, 'L'), (y2/b, x2, y2, 'R'))

def intersectx(a, b, R, a1, a2):
    k = b / a
    A = k**2 + 1
    B = -2 * ((a2 * k) + a1)
    C = a1**2 + a2**2 - R**2

    D = B**2 - 4 * A * C
    # print D
    if D < 0:
        return None
    odmD = math.sqrt(D)
    # x =a * y/b
    x1 = (-B + odmD)/(2*A)
    y1 = k * x1
    x2 = (-B - odmD)/(2*A)
    y2 = k * x2
    # print odmD
    if x1/a > x2/a:
        return ((x1/a, x1, y1, 'R'), (x2/a, x2, y2, 'L'))
    else:
        return ((x1/a, x1, y1, 'L'), (x2/a, x2, y2, 'R'))

def solve():
    inp = sys.stdin
    l = inp.readline()
    zz, D, a, b = l.split(" ")
    D=float(D)
    D+=.0000000001
    points = []
    for l in inp:
        a1, a2 = l.split(" ")
        if int(a) == 0:
            p = intersecty(float(a), float(b), D, float(a1),float(a2))
        else:
            p = intersectx(float(a), float(b), D, float(a1),float(a2))
        if p != None:
            points.append(p[0])
            points.append(p[1])
    # print(points)
    points.sort()
    # print points
    # print(points)
    maxi = 0
    act = 0
    for pp in points:
        if pp[3] == 'L':
            act+=1
        else:
            act-=1
        if maxi < act:
            maxi = act
    print(maxi)
solve()
