#include <bits/stdc++.h>
using namespace std;
typedef long long int ll;
typedef double ld;
typedef vector<ll> vi;
// push_back insert lower_bound upper_bound erase
#define F(a) for ( ll i = 0; i < (ll)(a); ++i )

#define EPS (1e-10)
bool eq(ld a, ld b) { return fabs(a-b) <= fabs(a+b) * EPS; }

struct Pt{
    ld x, y;
    ll flag;
    bool operator <(const Pt &p) const {
        return x < p.x-EPS || (eq(x, p.x) && y < p.y-EPS);
    }
    Pt operator+(const Pt &p){ return{x+p.x, y+p.y}; }
    Pt operator-(const Pt &p){ return{x-p.x, y-p.y}; }
    Pt operator-(){ return{-x, -y}; }
    Pt operator*(ld d){ return {x*d, y*d}; }
    Pt operator/(ld d){ return {x/d, y/d}; }
    friend ostream &operator<<(ostream &os, const Pt &a){ os<<a.x<<' '<<a.y; return os; }
    friend istream &operator>>(istream &is, Pt &a){ is>>a.x>>a.y; return is; }
};
struct Line {
    Pt a, b;
    bool operator<(Line &l){
        Pt v=b-a, w=l.b-l.a;
        return atan2(v.y, v.x) < atan2(w.y, w.x);
    }
};
struct Cir {
    Pt s;
    ld r;
    Pt point(double a)const{ return {s.x+cos(a)*r, s.y+sin(a)*r}; }  
    bool operator<(const Cir &a){ return r<a.r; }  
};
ld vec(Pt a, Pt b){ return a.x*b.y-a.y*b.x; }
ld vec(Pt a, Pt b, Pt c){ return vec(b-a, c-a); }
ld dot(Pt a, Pt b){ return a.x*b.x+a.y*b.y; }
ld norm(Pt a){ return hypot(a.x, a.y); }
ld line_point_dist(Line l, Pt p){ return fabs(vec(p-l.a, l.b-l.a)/norm(l.b-l.a)); }
Pt scale_to(Pt a, ld res){ return a*res/norm(a); }
Pt normal(Pt a){ ld n=norm(a); return {-a.y/n, a.x/n}; }
Pt lines_intersection(Line p, Line q){
    Pt v=p.b-p.a;
    Pt w=q.b-q.a;
    ld t=vec(w, p.a-q.a)/vec(v, w);
    return p.a+v*t;
}
Pt line_point_closest_point(Line a, Pt b){
    return lines_intersection(a, {b, b+normal(a.b-a.a)});
}
ld circle_line_distance(Cir &a, Line &b){
    return max(line_point_dist(b, a.s)-a.r, 0.);
}
ll circle_line_intersection(Cir a, Line b, Pt &p1, Pt &p2){
    if(circle_line_distance(a, b)>0)return 0;
    Pt dv = line_point_closest_point(b, a.s);
    ld d = norm(dv-a.s);
    ld h = sqrt(a.r*a.r-d*d);
    Pt n = scale_to(b.b-b.a, h);
    p1 = dv+n;
    p2 = dv-n;
    return 1+!(eq(p1.x, p2.x) && eq(p1.y, p2.y)); // returns the number of intersections
}

int main(){
    ll N;
    ld R;
    Line l;
    l.a = {0, 0};
    cin >> N >> R >> l.b;
    R += 0.001;
    vector<Cir> a(N, {{0,0},R+EPS});
    F(N) cin >> a[i].s;
    vector<Pt> p;
    F(N){
        Pt q, w;
        ll e = circle_line_intersection(a[i], l, q, w);
        if(e){
            q.flag = +1;
            w.flag = -1;
            p.push_back(q);
            p.push_back(w);
        }
    }
    sort(p.begin(), p.end());
    //for(Pt q:p)cerr<<q<<endl;
    ll mx=0,s=0;
    for(Pt q : p){
        s += q.flag;
        mx = max(mx, abs(s));
    }
    cout<<mx<<endl;
    return 0;
}

