import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;


/**
 * ICPC - CTU Open Contest 2019
 * Sample Solution: Bob in Wonderland (Chains)
 * 
 * @author Martin Kacer
 */
public class Chains {
	StringTokenizer st = new StringTokenizer("");
	BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
	boolean hasNextToken() {
		try {
			while (!st.hasMoreTokens()) {
				String line = input.readLine();
				if (line == null) return false;
				st = new StringTokenizer(line);
			}
		} catch (IOException ex) { throw new RuntimeException(ex); }
		return true;
	}
	String nextToken() {
		return (!hasNextToken()) ? null : st.nextToken();
	}
	int nextInt() {
		return Integer.parseInt(nextToken());
	}
	public static void main(String[] args) {
		new Chains().run();
	}
	
	void run() {
		int n = nextInt(), leafs = 0;
		int[] deg = new int[n];
		for (int i = 2; i < 2*n; ++i) ++deg[nextInt()-1];
		for (int d : deg) if (d == 1) ++leafs;
		System.out.println(leafs == 0 ? 0 : leafs - 2);
	}
}
