#include <bits/stdc++.h>
using namespace std;
typedef long long int ll;
typedef long double ld;

#define EPS (1e-10)
#define EQ(a,b) (fabs(a-b) <= fabs(a+b) * EPS)

/**
 * ICPC Central Europe Regional Contest 2018
 * Sample solution: Mirrority Report
 * 
 * @author Vaclav Blazej
 */

// list all combinations of c elements in n
// ex for c=3,n=5: [0 1 2],[0 1 3],[0 1 4],[1 2 3], ...
vector<vector<ll>> all_combinations(ll c, ll n){
    vector<vector<ll>> res;
    vector<ll> permutation(c);
    for(int i=0; i<c; ++i) permutation[i]=i-(i==c-1);
    while(true){
        ll cnt=0,idx=c-1,val=n-1;
        while(cnt<c && permutation[idx]>=val-cnt){ ++cnt; --idx; }
        if(cnt==c)break;
        permutation[idx]++;
        while(++idx<c){
            permutation[idx]=permutation[idx-1]+1;
        }
        res.push_back(permutation);
    }
    if(c==0)res.push_back(vector<ll>());
    return res;
}

struct Pt{
    ld x,y;
	Pt operator-(){return{-x,-y};}
	Pt operator+(const Pt&p){return{x+p.x,y+p.y};}
	Pt operator-(const Pt&p){return{x-p.x,y-p.y};}
	Pt operator*(ld d){return {x*d,y*d};}
	Pt operator/(ld d){return {x/d,y/d};}
    friend ostream &operator<<(ostream &os, const Pt&a){
        os<<a.x<<' '<<a.y;
        return os;
    }
    friend istream &operator>>(istream &is, Pt&a){
        is>>a.x>>a.y;
        return is;
    }
};
struct Line{
    Pt a,b;
    ll time,id;
    friend ostream &operator<<(ostream &os, const Line&a){
        os<<a.a<<' '<<a.b;
        return os;
    }
};
Pt s,e;
vector<Line> a;
ld cross(Pt a, Pt b){ return a.x*b.y-a.y*b.x; }
ld cross(Pt a, Pt b, Pt c){ return cross(b-a,c-a); }
ld dot(Pt a, Pt b){ return a.x*b.x+a.y*b.y; }
ld norm(Pt a){ return sqrt(dot(a,a)); }
ld line_point_dist(Line l, Pt p){
    return fabs(cross(p-l.a,l.b-l.a)/norm(l.b-l.a));
}
Pt lines_intersection(Line p,Line q){
	Pt v=p.b-p.a;
	Pt w=q.b-q.a;
	ld t=cross(w,p.a-q.a)/cross(v,w);
	return p.a+v*t;
}
bool have_intersection(Line p,Line q){
	Pt v=p.b-p.a;
	Pt w=q.b-q.a;
	ld t=cross(v,w);
    return abs(t)>EPS;
}

void mirror(Pt &what, Line by){
    ld dist=line_point_dist(by,what);
    Pt d=by.b-by.a;
    d={d.y,-d.x};
    if(dot(d,what-by.a)>0)d=-d;
    d=d*dist/norm(d);
    what=what+d*2;
}
void mirror(Line &what, Line by){
    mirror(what.a,by);
    mirror(what.b,by);
}

int main(){
    ll N;cin>>N;
    a=vector<Line>(N);
    cin>>s.x>>s.y>>e.x>>e.y;
    for(int i=0; i<N; ++i){
        cin>>a[i].a>>a[i].b;
    }
    vector<ld> directions;
    vector<vector<ll>> resultPermutations;
    for(int c=0;c<=N;++c){
        auto r=all_combinations(c,N);
        for(vector<ll> p:r)do{
            Pt ee=e;
            vector<Line> copy(a.begin(),a.end());
            vector<bool> done(N,false);
            vector<Line> presentLines;
            map<ll,vector<Pt>> forbiddenTimePoints;
            ll idx=0;
            while(true){
                for(int i=0; i<copy.size(); ++i){
                    if(!done[i]){
                        Line nl=copy[i];nl.time=idx;nl.id=i;
                        presentLines.push_back(nl);
                    }
                }
                if(idx>=p.size())break;
                for(int i=0; i<copy.size(); ++i){
                    if(!done[i]){
                        for(int j=i+1; j<copy.size(); ++j){
                            if(!done[j]){
                                if(have_intersection(copy[i],copy[j])){
                                    Pt p=lines_intersection(copy[i],copy[j]);
                                    forbiddenTimePoints[idx].push_back(p);
                                }
                            }
                        }
                    }
                }
                Line mir=copy[p[idx]];
                done[p[idx]]=1;
                mirror(ee,mir);
                for(int i=0; i<copy.size(); ++i){
                    if(i!=p[idx]) mirror(copy[i],mir);
                }
                ++idx;
            }
            Line dir={s,ee};
            if(norm(dir.a-dir.b)<1e-2)continue;
            vector<Pt> intersections(presentLines.size());
            vector<bool> parallel(presentLines.size(),0);
            for(int i=0; i<presentLines.size(); ++i){
                Line l=presentLines[i];
                if(!EQ(0,cross(dir.b-dir.a,l.b-l.a))){
                    intersections[i]=lines_intersection(l,dir);
                }else{
                    parallel[i]=1;
                }
            }
            vector<pair<ld,ll>> distance(presentLines.size());
            ld goalDistance = norm(dir.b-dir.a);
            for(int i=0; i<presentLines.size(); ++i){
                if(!parallel[i] && dot(dir.b-dir.a,intersections[i]-dir.a)>0){
                    distance[i].first=norm(intersections[i]-dir.a);
                }else{
                    distance[i].first=-1; // never crosses
                }
                distance[i].second=i;
            }
            sort(distance.begin(),distance.end());
            ll time=0;
            bool good=1;
            for(int i=0; i<distance.size(); ++i){
                if(distance[i].first<0)continue;
                if(distance[i].first>goalDistance){
                    break;
                }
                ll j=distance[i].second;
                if(presentLines[j].time==time){
                    if(time < p.size() && presentLines[j].id==p[time]){
                        Pt currentInterection = lines_intersection(presentLines[j],dir);
                        for(Pt p:forbiddenTimePoints[time]){
                            if(norm(p-currentInterection) < 1e-4){
                                good=0;
                                break;
                            }
                        }
                        time++;
                    }else{
                        good=0; break;
                    }
                }
            }
            if(good && time==p.size()){
                ld d=atan2(dir.b.y-dir.a.y,dir.b.x-dir.a.x);
                directions.push_back(d);
                resultPermutations.push_back(p);
            }
        }while(next_permutation(p.begin(),p.end()));
    }
    vector<bool> unique(directions.size(),true);
    for(int i=0; i<directions.size(); ++i){
        for(int j=i+1; j<directions.size(); ++j){
            if(abs(directions[i]-directions[j])<1e-6){
                unique[j]=false;
            }
        }
    }

    // compile with -DPAINT to output asymptote code into stderr
    // compile asymptote with: asy <file.asy>
#ifdef PAINT
    cerr<<"settings.outformat=\"pdf\";\n";
    cerr<<"unitsize(0.2cm);\n";
    cerr<<"real r = 1.5;\n";
    cerr<<"fill(circle(("<<s.x<<","<<s.y<<"),r),blue);\n";
    cerr<<"label(\"start\",("<<s.x<<","<<(s.y-2)<<"));\n";
    cerr<<"fill(circle(("<<e.x<<","<<e.y<<"),r),red);\n";
    cerr<<"label(\"end\",("<<e.x<<","<<(e.y-2)<<"));\n";
    cerr<<"pen black=rgb(0,0,0);\n";
    for(Line l:a){
        Line n=l;
        Pt v=n.b-n.a;
        n.b=n.a+v*10;
        n.a=n.a-v*10;
        cerr<<"draw(("<<n.a.x<<","<<n.a.y;
        cerr<<") -- ("<<n.b.x<<","<<n.b.y<<"),black);\n";
    }
    ll blue=0;
    for(int i=0; i<directions.size(); ++i){
        Pt v={cos(directions[i]),sin(directions[i])};
        Line n={s,s+v*10};
        vector<ll> permutation=resultPermutations[i];
        Pt last=s,cur;
        cerr<<"pen blue=rgb(0,0,255);\n";
        blue=min(255ll,blue+(ll)(255/directions.size()));
        for(int j=0; j<permutation.size(); ++j){
            Line &l=a[permutation[j]];
            cur=lines_intersection(n,l);
            mirror(n,l);
            cerr<<"draw(("<<last.x<<","<<last.y;
            cerr<<") -- ("<<cur.x<<","<<cur.y<<"),blue+dashed);\n";
            last=cur;
        }
        cerr<<"draw(("<<last.x<<","<<last.y;
        cerr<<") -- ("<<e.x<<","<<e.y<<"),blue+dashed);\n";
    }
    cerr<<"clip(box((-100,-100),(100,100)));\n";
#endif
    ll res=directions.size();
    ll res2=0;
    for(bool b:unique)res2+=b;
    cout<<res2<<endl;
    return 0;
}

