#include <bits/stdc++.h>
using namespace std;
typedef long long int ll;
typedef long double ld;

/**
 * ICPC Central Europe Regional Contest 2018
 * Sample solution: Reservoir Dog
 * 
 * @author Vaclav Blazej
 */

#define EPS (1e-8)

ld search(ld low, ld high, bool(*cmp)(ld)){
	ld mid;
	while(abs(low-high)>EPS){
		mid = (low+high)/2;
		if(cmp(mid)) high = mid;
		else low = mid+EPS;
	}
	return low;
}

ld tf,vf,hf,td,vd,hd;
ld af=1,ad=3;
ld fallTime;
bool cmp(ld totalTime){
    if(totalTime < td)return false;
    ld dtf=max((ld)0,min(fallTime,totalTime-tf));
    ld dtd=max((ld)0,totalTime-td);
    ld y=max((ld)0,hf-af*dtf*dtf/2);
    if(hd<y)return false;
    ld minytime=(sqrt(2*ad*hd)-sqrt(2*ad*hd-2*ad*y))/ad;
    ld x=dtf*vf;
    ld minxtime=x/vd;
    return max(minxtime,minytime) <= dtd;
}

int main(){
    cin>>tf>>vf>>hf>>td>>vd>>hd;
    fallTime=sqrt(2*hf/af);
    ld t=search(0,1e12,cmp);
    ld flightTime=max((ld)0,min(fallTime,t-tf));
    ld xf=vf*flightTime;
    ld res=t+xf/vd;
    cout<<fixed<<setprecision(8);
    cout<<res<<endl;
    return 0;
}

