import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.StringTokenizer;

/**
 * ICPC Central Europe Regional Contest 2018
 * Sample solution: Clockwork ||ange
 * 
 * @author Martin Kacer
 */
public class OrangeSimpleBFS {
	StringTokenizer st = new StringTokenizer("");
	BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
	String nextLine() {
		try {
			return input.readLine();
		} catch (IOException ex) { throw new RuntimeException(ex); }
	}
	public static void main(String[] args) {
		System.out.println(new OrangeSimpleBFS().run());
	}
	
	Queue<Long> q = new LinkedList<>();
	Map<Long, Integer> dist = new HashMap<>();
	
	void enqueue(long n, int d) {
		if (dist.containsKey(n)) return;
		dist.put(n, d);
		q.add(n);
	}
	
	int run() {
		String input = nextLine();
		long val = Long.parseLong(input, 2);
		int len = input.length();
		if (Long.bitCount(val) == len) return 0;
		enqueue(val, 0);
		Long n;
		while ((n = q.poll()) != null) {
			int d = dist.get(n);
			for (int i = 1; i < len; ++i) {
				long x = n | (n >> i);
				if (Long.bitCount(x) == len) return d+1;
				enqueue(x, d + 1);
			}
		}
		return -1;
	}
}
