import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

/**
 * ICPC Central Europe Regional Contest 2018
 * Wrong solution: Silence of the Dumps
 * This is intentionally wrong to validate the quality of test data.
 * <p>
 * This solution incorrectly assumes that a "higher" player
 * wins always if there is at least one pile large enough.
 * It forgets the special case where the first player to move
 * makes the pile small.
 * 
 * @author Martin Kacer
 */
public class StonesGameWoutSpecialMK {
	StringTokenizer st = new StringTokenizer("");
	BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
	boolean hasNextToken() {
		try {
			while (!st.hasMoreTokens()) {
				String line = input.readLine();
				if (line == null) return false;
				st = new StringTokenizer(line);
			}
		} catch (IOException ex) { throw new RuntimeException(ex); }
		return true;
	}
	String nextToken() {
		return (!hasNextToken()) ? null : st.nextToken();
	}
	int nextInt() {
		return Integer.parseInt(nextToken());
	}	
	public static void main(String[] args) {
		System.out.println(new StonesGameWoutSpecialMK().run() != 0 ? "Petyr" : "Varys");
	}
	
	int[] piles;
	
	int run() {
		int n = nextInt(), a = nextInt(), b = nextInt(), g = Math.min(a,  b), big = 0, bidx = -1;
		piles = new int[n];
		for (int i = 0; i < n; ++i) if ((piles[i] = nextInt()) > g) { ++big; bidx = i; }
		int res = 0;
		for (int i = 0; i < n; ++i) res ^= (piles[i] % (g+1));
		// this is the missing part:
		//if (big == 1 && b > g)
		//	return (piles[bidx] - (res ^ (piles[bidx] % (g+1))) <= g) ? 1 : 0;
		if (big >= 1) {
			if (a > g) return 1;
			if (b > g) return 0;
			for (int i = 0; i < n; ++i) piles[i] %= g;
		}
		return res;
	}
}
