import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

/**
 * ICPC Central Europe Regional Contest 2018
 * Sample solution: Game of Stones
 * 
 * @author Martin Kacer
 */
public class StonesGameMK {
	StringTokenizer st = new StringTokenizer("");
	BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
	boolean hasNextToken() {
		try {
			while (!st.hasMoreTokens()) {
				String line = input.readLine();
				if (line == null) return false;
				st = new StringTokenizer(line);
			}
		} catch (IOException ex) { throw new RuntimeException(ex); }
		return true;
	}
	String nextToken() {
		return (!hasNextToken()) ? null : st.nextToken();
	}
	int nextInt() {
		return Integer.parseInt(nextToken());
	}	
	public static void main(String[] args) {
		System.out.println(new StonesGameMK().run() != 0 ? "Petyr" : "Varys");
	}
	
	int[] piles;
	
	int run() {
		int n = nextInt(), a = nextInt(), b = nextInt(), g = Math.min(a,  b), big = 0, bidx = -1;
		piles = new int[n];
		for (int i = 0; i < n; ++i) if ((piles[i] = nextInt()) > g) { ++big; bidx = i; }
		int res = 0;
		// XOR the heights (modulo)
		for (int i = 0; i < n; ++i) res ^= (piles[i] % (g+1));
		if (big == 1 && b > g) {
			// a special case:
			// if there is exactly one pile larger than the (lower) limit
			// AND the player with lower limit plays first
			// AND the first move can make a "zero game" (while going below the game limit)
			// then the first player wins in spite of the lower limit
			int first = piles[bidx] - (res ^ (piles[bidx] % (g+1)));
			return (first > 0 && first <= g) ? 1 : 0;
		}
		if (big >= 1) {
			// the player with the higher limit always wins
			// if there are any piles larger than the limit of the other player
			if (a > g) return 1;
			if (b > g) return 0;
			for (int i = 0; i < n; ++i) piles[i] %= g;
		}
		// otherwise, it is a "standard" game, return the XOR
		return res;
	}
}
