import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

/**
 * ICPC Central Europe Regional Contest 2018
 * Sample solution: Matrice
 * 
 * @author Martin Kacer
 */
public class MatriceMK {
	StringTokenizer st = new StringTokenizer("");
	BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
	boolean hasNextToken() {
		try {
			while (!st.hasMoreTokens()) {
				String line = input.readLine();
				if (line == null) return false;
				st = new StringTokenizer(line);
			}
		} catch (IOException ex) { throw new RuntimeException(ex); }
		return true;
	}
	String nextToken() {
		return (!hasNextToken()) ? null : st.nextToken();
	}
	int nextInt() {
		return Integer.parseInt(nextToken());
	}	
	public static void main(String[] args) {
		new MatriceMK().run();
	}

	int rows, cols;
	char[][] map;
	int revR, revC;
	
	char at(int x, int y) {
		if (x < 0 || x >= rows || y < 0 || y >= cols) return 0;
		return map[revR>0 ? rows-1-x : x][revC>0 ? cols-1-y : y];
	}
	
	void run() {
		rows = nextInt(); cols = nextInt();
		map = new char[rows][];
		for (int i = 0; i < rows; ++i) map[i] = nextToken().toCharArray();

		int sum = 0;
		for (revR = 0; revR < 2; ++revR) for (revC = 0; revC < 2; ++revC) {
			int[][] res = new int[rows][cols];
			for (int i = 0; i < rows; ++i)
				for (int j = 0; j < cols; ++j)
					if (at(i,j) == at(i-1,j) && at(i,j) == at(i,j-1))
						sum += (res[i][j] = Math.min(res[i-1][j], res[i][j-1]) + 1);
		}
		System.out.println(sum);
	}
}
