import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

/**
 * ICPC Central Europe Regional Contest 2018
 * Sample solution: Silence of the Lamps
 * 
 * @author Martin Kacer
 */
public class DumpsMK {
	StringTokenizer st = new StringTokenizer("");
	BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
	boolean hasNextToken() {
		try {
			while (!st.hasMoreTokens()) {
				String line = input.readLine();
				if (line == null) return false;
				st = new StringTokenizer(line);
			}
		} catch (IOException ex) { throw new RuntimeException(ex); }
		return true;
	}
	String nextToken() {
		return (!hasNextToken()) ? null : st.nextToken();
	}
	int nextInt() {
		return Integer.parseInt(nextToken());
	}	
	public static void main(String[] args) {
		new DumpsMK().run();
	}
	
	static final int MAX = 1000000;
	int[] res = new int[MAX+1];
	
	void run() {
		for (int i = 1; i <= MAX; ++i)
			for (int j = i+1; (long)i*j <= MAX; ++j)
				for (int k = j+1; (long)i*j*k <= MAX; ++k)
					++res[i*j*k];
		for (int i = 1, sum = 0; i <= MAX; ++i) {
			sum += res[i]; res[i] = sum;
		}
		int qc = nextInt();
		for (int i = 0; i < qc; ++i)
			System.out.println(res[nextInt()]);
	}
}
