#include <bits/stdc++.h>
using namespace std;
typedef long long int ll;
typedef double ld;

struct Pt{
    ll x,y,id;
	Pt operator-(){return{-x,-y};}
	Pt operator+(const Pt&p){return{x+p.x,y+p.y};}
	Pt operator-(const Pt&p){return{x-p.x,y-p.y};}
	Pt operator*(ll d){return {x*d,y*d};}
	Pt operator/(ll d){return {x/d,y/d};}
    bool operator<(const Pt&a)const{ return id<a.id; }
    friend ostream &operator<<(ostream &os, const Pt&a){
        os<<a.x<<' '<<a.y;
        return os;
    }
    friend istream &operator>>(istream &is, Pt&a){
        is>>a.x>>a.y;
        return is;
    }
};

struct Cmp{ bool operator()(const Pt&a, const Pt&b)const{ return (a.x != b.x) ? a.x < b.x : a.y < b.y; } };

ll cross(Pt a, Pt b){ return a.x*b.y-a.y*b.x; }
ll cross(Pt a, Pt b, Pt c){ return cross(b-a,c-a); }
vector<Pt> convex_hull(vector<Pt> p) {
	vector<Pt> r(2 * p.size() + 14);
	ll K = 0;
	sort(p.begin(), p.end(), Cmp());
	for(Pt e:p){
		while (K >= 2 && cross(r[K-1]-r[K-2], e-r[K-2]) <= 0) K--;
		r[K++] = e;
	}
	for(ll i=p.size()-2, T=K+1; i>=0; i--){
		while (K >= T && cross(r[K-1]-r[K-2], p[i]-r[K-2]) <= 0) K--;
		r[K++] = p[i];
	}
	r.resize(K);
	r.pop_back();
	return r;
}
///conhull
Pt c;
bool cmp(Pt &a,Pt &b){
    Pt da=a-c;
    Pt db=b-c;
    ld aa=atan2(da.y,da.x);
    ld bb=atan2(db.y,db.x);
    return aa<bb;
}

#define TAU (2*M_PI)

int main(){
    ll N;cin>>N;
    vector<Pt> b(N);
    ll idx=0;
    for(Pt &p:b){ cin>>p; p.id=idx++; }
    vector<Pt> a=convex_hull(b);
    if(a.size()==b.size()){
        cout<<"3 "<<(N-2)<<" "<<N<<endl;
    }else{
        c={0,0,1<<30};
        for(Pt &d:a)if(d.id<c.id)c=d;
        set<ld> s;
        map<ld,ll> m;
        for(Pt &d:a)s.insert(fmod(atan2(d.y-c.y,d.x-c.x)+TAU,TAU));
        s.insert((*s.begin())+TAU);
        set<Pt> rest(b.begin(),b.end());
        for(Pt &d:a)rest.erase(d);
        for(ld w:s)m[w]=0;
        for(const Pt &d:rest){
            ld q=*s.lower_bound(fmod(atan2(d.y-c.y,d.x-c.x)+TAU,TAU));
            if(q>=TAU)q-=TAU;
            m[q]++;
        }
        ll M=a.size()-1;
        vector<bool> f(M,0);
        ll idx=0;
        for(const pair<ld,ll> &p:m){
            ld value=p.first;
            ll count=p.second;
            if(count){
                f[idx]=1;
                f[(idx+1)%M]=1;
            }
            idx++;
        }
        //cout<<"m:\n";
        //for(const pair<ld,ll> &p:m){
        //    cout<<p.first<<' '<<p.second<<endl;
        //}
        //cout<<"f: ";for(bool n:f)cout<<n<<' ';cout<<endl;
        ll cnt=rest.size();
        ll res=1+cnt;
        for(int i=0; i<M; ++i){ res+=f[i]; }
        //cout<<"c: ";for(Pt c:a)cout<<c<<endl;
        //cout<<"rest: ";for(Pt c:rest)cout<<c<<endl;
        cout<<"4 "<<cnt<<" "<<res<<endl;
    }
}

