import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

/**
 * ICPC Central Europe Regional Contest 2018
 * Sample solution: Reservoir Dog
 * 
 * This is a constant-time solution that solves a quadratic equation.
 * Many comments are included to explain the calculation.
 * 
 * @author Martin Kacer
 */
public class FrisbeeDogMK {
	StringTokenizer st = new StringTokenizer("");
	BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
	boolean hasNextToken() {
		try {
			while (!st.hasMoreTokens()) {
				String line = input.readLine();
				if (line == null) return false;
				st = new StringTokenizer(line);
			}
		} catch (IOException ex) { throw new RuntimeException(ex); }
		return true;
	}
	String nextToken() {
		return (!hasNextToken()) ? null : st.nextToken();
	}
	int nextInt() {
		return Integer.parseInt(nextToken());
	}	
	public static void main(String[] args) {
		System.out.printf("%.8f\n",new FrisbeeDogMK().run());
	}

	static final double af = 1, ad = 3;
	
	double run() {
		double tf = nextInt(), vf = nextInt(), hf = nextInt(), td = nextInt(), vd = nextInt(), hd = nextInt();
		double t2 = td - tf,  // delay before dog released
				tjrel = Math.sqrt(2 * hd / ad),  // time of jump (to get to the highest point)
				hfd = hf - t2*t2 * af/2,  // height of frisbee when the dog is released
				hfj = hf - (t2+tjrel)*(t2+tjrel) * af/2;  // maximal height of frisbee when the dog is in the highest point
		double tvert;  // the earliest time the dig may reach the frisbee vertically
		if (hfd < 0) {
			tvert = td; // frisbee already on the ground when the dog is released
        } else if (hfj > hd) {
			tvert = tf + Math.sqrt(2 * (hf-hd) / af); // dog catches the frisbee in the maximal height (=> time is when the disc gets to that height)
        } else {
			double vj = ad * tjrel,  // vertical speed of the jump
					vfdvert = af * t2,  // vertical speed of the frisbee when dog jumps
					d = 4 * (vj+vfdvert) * (vj+vfdvert) - 8 * (ad-af) * hfd,  // discriminant of the quadratic equation
					trel = (2 * (vj+vfdvert) - Math.sqrt(d)) / 2 / (ad-af);  // MINUS = always take the first solution
			tvert = td + trel;
		}
		double xf = (tvert-tf) * vf, xd = (tvert-td) * vd;  // frisbee position at the time when the dog catches is vertically
		if (xd > xf) {
            return tvert + xf/vd;  // the dog can make it (the vertical component determines the result), just add the time to go back
        }
		// otherwise, the horizontal component determines the result
		double tf0rel = Math.sqrt(2 * hf / af),  // time AFTER which the frisbee touches the ground
				xf0 = vf * tf0rel,  // corresponding position
				td0 = td + xf0 / vd,  // when the dog reaches the touch-down point
				tpick = td0 + xf0 / vd,  // return after pickup from the ground
				tcatch = (vd < vf) ? Double.POSITIVE_INFINITY : td + 2 * vf * (td-tf) / (vd-vf);  // return after catching moving disc (possibly "below" the ground, see below)
		return Math.min(tcatch, tpick);  // take the better (this alsp eliminates the "below the ground" case)
	}
}
