import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/**
 * ICPC Central Europe Contest 2018
 * Sample solution: ABCD Murderer
 * <p>
 * This should be a O(n.sqrt(n)) solution, times some hashing
 * and with relatively large constants due to a large amount of objects.
 * Many optimizations are possible but let's try (and measure) this first.
 * 
 * @author Martin Kacer
 */
public class StrikethroughList {
	StringTokenizer st = new StringTokenizer("");
	BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
	String nextLine() {
		try {
			return input.readLine();
		} catch (IOException ex) { throw new RuntimeException(ex); }
	}
	public static void main(String[] args) {
		new StrikethroughList().run();
	}
	
	static final int MOD = 10000103, MUL = 37;
	
	static class Word {
		final String word;
		int lastMatch = -1, period;
		Word(String w) { word = w; }
	}

	String text;
	Map<Integer,List<String>> byLength = new HashMap<>();
	Map<Integer,List<Word>> byHash = new HashMap<>();
	int[] maxlen;
	
	boolean checkPeriod(String w, int per) {
		if (w.length() % per != 0) return false;
		for (int i = per; i < w.length(); i += per)
			for (int j = 0; j < per; ++j)
				if (w.charAt(j) != w.charAt(i+j)) return false;
		return true;
	}
	
	boolean compare(Word wrd, int pos) {
		int len = wrd.word.length();
		if (wrd.lastMatch >= 0 && pos - wrd.lastMatch < len) {
			if (wrd.period != pos - wrd.lastMatch && checkPeriod(wrd.word, pos - wrd.lastMatch))
				wrd.period = pos - wrd.lastMatch;
			if (wrd.period == pos - wrd.lastMatch) {
				wrd.lastMatch = pos;
				return true;
			}
		}
		for (int i = 0; i < len; ++i)
			if (wrd.word.charAt(i) != text.charAt(pos+i)) return false;
		wrd.lastMatch = pos;
		return true;
	}

	void run() {
		int words = Integer.valueOf(nextLine());
		text = nextLine();
		for (int i = 0; i < words; ++i) {
			String w = nextLine();
			List<String> blen = byLength.get(w.length());
			if (blen == null) byLength.put(w.length(), blen = new ArrayList<>());
			blen.add(w);
		}
		maxlen = new int[text.length()];
		for (Map.Entry<Integer,List<String>> me : byLength.entrySet()) {
			int len = me.getKey(), mul2len = 1;
			if (len > text.length()) continue;
			for (int i = 0; i < len; ++i) mul2len = mul2len * MUL % MOD;
			byHash.clear();
			for (String w : me.getValue()) {
				int hash = 0;
				for (char c : w.toCharArray()) hash = (hash * MUL + c) % MOD;
				List<Word> bha = byHash.get(hash);
				if (bha == null) byHash.put(hash, bha = new LinkedList<>());
				bha.add(new Word(w));
			}
			int hash = 0;
			for (int i = 0; i < len; ++i) hash = (hash * MUL + text.charAt(i)) % MOD;
			for (int i = len; ; ++i) {
				List<Word> bha = byHash.get(hash);
				if (bha != null && maxlen[i-len] < len) {
					for (Word wrd : bha) if (compare(wrd, i-len)) maxlen[i-len] = len;
				}
				if (i == text.length()) break;
				hash = (hash * MUL) + text.charAt(i) - mul2len * text.charAt(i-len);
				if (hash < 0) hash += MOD * (-hash / MOD + 1);
				hash %= MOD;
			}
		}
		System.out.println(countResult());
	}
	
	int countResult() {
		int cnt = 0, next = 0, reach = 0;
		for (int i = 0; i < text.length(); ++i) {
			if (i + maxlen[i] > reach) reach = i + maxlen[i];
			if (i == next) {
				if (reach <= i) return -1;
				++cnt; next = reach;
			}
		}
		return cnt;
	}
}
