// Author: Ivan Katanic

#include <algorithm>
#include <cassert>
#include <cstring>
#include <iostream>

using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)
#define TRACE(x) cout << #x << " = " << x << endl
#define _ << " _ " <<

typedef long long llint;

const int MAX = 505;
const int K = 7;

int mod(int x) {
  return (x % K + K) % K;
}

vector<int> transform(vector<string> numbers) {
  vector<int> ret;
  for (string number: numbers) {
    bool dont_care = true;
    REP(i, K) dont_care &= number[i] == number[0];
    if (dont_care) continue;

    string best = number;
    int best_i = 0;
    REP(i, K) {
      if (number > best) {
        best = number;
        best_i = i;
      }
      rotate(number.begin(), number.begin() + 1, number.end());
    }
    ret.push_back(best_i);
  }
  return ret;
}

int solve(vector<int> b) {
  // partition into max. number of groups divisible by K
  vector<int> c(K);
  for (int x: b) c[x]++;

  int ret = c[0];
  c[0] = 0;
  for (int i = 1; i < K-i; ++i) {
    int d = min(c[i], c[K-i]);
    ret += d;
    c[i] -= d;
    c[K-i] -= d;
  }

  vector<pair<int, int>> r;
  REP(i, K) {
    if (c[i] > 0) {
      r.push_back({i, c[i]});
    }
  }

  while (r.size() < 3) r.push_back({0, 0});
  assert((int)r.size() == 3);

  int vx = r[0].first, cx = r[0].second;
  int vy = r[1].first, cy = r[1].second;
  int vz = r[2].first, cz = r[2].second;
  
  static int f[MAX][MAX][K];
  static int nf[MAX][MAX][K];

  REP(y, cy+1) REP(z, cz+1) REP(k, K) f[y][z][k] = -1;
  f[0][0][0] = 0;

  
  REP(x, cx+1) {
    REP(y, cy+1) REP(z, cz+1) REP(k, K) nf[y][z][k] = -1;
    
    REP(y, cy+1) REP(z, cz+1) REP(k, K) {
      if (f[y][z][k] != -1) {
        if (x + 1 <= cx) { // take first
          int nk = mod(k + vx);
          nf[y][z][nk] = max(nf[y][z][nk], f[y][z][k] + (nk == 0));
        }
        if (y + 1 <= cy) { // take second
          int nk = mod(k + vy);
          f[y+1][z][nk] = max(f[y+1][z][nk], f[y][z][k] + (nk == 0));
        }
        if (z + 1 <= cz) { // take third
          int nk = mod(k + vz);
          f[y][z+1][nk] = max(f[y][z+1][nk], f[y][z][k] + (nk == 0));
        }
      }
    }

    if (x < cx) {
      REP(y, cy+1) REP(z, cz+1) REP(k, K) f[y][z][k] = nf[y][z][k];
    }
  }

  return ret + f[cy][cz][0];
}

int main(void) {
  int n;
  scanf("%d", &n);

  vector<string> numbers;
  REP(i, n) {
    static char buf[10];
    scanf("%s", buf);
    numbers.push_back(buf);
  }

  vector<int> a = transform(numbers);
  a.insert(a.begin(), 0);
  a.push_back(0);
                                     
  vector<int> b;
  REP(i, (int)a.size() - 1) {
    b.push_back(mod(a[i + 1] - a[i]));
  }
  
  int ret = (int)b.size() - solve(b);
  printf("%d\n", ret);
  return 0;
}
