// Author: Ivan Paljak
#include <cstdio>
#include <vector>

using namespace std;

const int MAXN = 1e6 + 10;

int n;
int cnt[MAXN], subtree[MAXN];

vector<int> div, sol;
vector<int> v[MAXN];

int gcd(int a, int b) {
  if (b == 0) return a;
  return gcd(b, a % b);
}

void dfs(int node, int parent) {
  subtree[node] = 1;
  for (int nxt : v[node]) {
    if (nxt == parent) continue;
    dfs(nxt, node);
    subtree[node] += subtree[nxt];
  }
  if (node != 0)
    cnt[gcd(subtree[node], n)]++;
}

int main(void) {
  scanf("%d", &n);
  for (int i = 0; i < n - 1; ++i) {
    int a, b;
    scanf("%d%d", &a, &b); --a; --b;
    v[a].push_back(b);
    v[b].push_back(a);
  }

  dfs(0, -1);

  for (int i = 1; i < n; ++i)
    if (n % i == 0)
      div.push_back(i);

  for (int i = 0; i < (int) div.size(); ++i)
    for (int j = i + 1; j < (int) div.size(); ++j)
      if (div[j] % div[i] == 0)
        cnt[div[i]] += cnt[div[j]];

  for (int d : div)
    if (cnt[d] == n / d - 1)
      sol.push_back(n / d - 1);

  for (auto it = sol.rbegin(); it != sol.rend(); ++it)
    printf("%d ", *it);
  printf("\n");

  return 0;
}
