#!/usr/bin/python2
# Author: Ante Derek

import sys

size = {}
dirs = {}

def add_file(fname, fsize):
    parts = fname[1:].split('/')
    prev = None
    for i in xrange(len(parts)):
        name = '/'.join(['']+parts[0:i])+'/'
        if not name in size:
            size[name] = 0
        if not name in dirs:
            dirs[name] = set()
        size[name] += fsize
        if prev:
            dirs[prev].add(name)
        prev = name


def read_files():
    n = int(sys.stdin.readline())
    for _ in xrange(n):
        fname, fsize = sys.stdin.readline().split()
        add_file(fname, int(fsize))


def output(name, t):
    if not dirs[name]:
        print('  {} {}'.format(name, size[name]))
        return
    if any(size[d] >= t for d in dirs[name]):
        print('- {} {}'.format(name, size[name]))
        for d in sorted(dirs[name]):
            output(d, t)
        return
    print('+ {} {}'.format(name, size[name]))


if __name__ == '__main__':
    read_files()
    t = int(sys.stdin.readline())
    output('/', t)
