// Author: Luka Kalinovcic
#include <algorithm>
#include <cstdio>

typedef long long int64;
typedef std::pair<int, int> Result;
const Result kNone(-1, -1);

int Mult(int a, int b, int p) {
  return ((int64)a * b) % p;
}

int Pow(int a, int n, int p) {
  if (n == 0) return 1;
  if (n % 2 == 1) return Mult(a, Pow(a, n - 1, p), p);
  const int x = Pow(a, n / 2, p);
  return Mult(x, x, p);
}

int Inverse(int a, int p) {
  return Pow(a, p - 2, p);
}

Result SolveZero(int64 n, int p) {
  if (n <= 2) return kNone;
  if (p == 2) return Result(3, 1);
  if (n >= p) return Result(2, 1);
  return kNone;
}

Result SolveNonzero(int64 n, int p, int r) {
  if (n >= 2 * p) return kNone;
  int fact = 1;
  for (int i = 2; i <= n; ++i) {
    if (i != p) {
      fact = Mult(fact, i, p);
    }
  }
  const int inv_fact = Inverse(fact, p);
  if (n >= p) {
    const int x = Mult(r, inv_fact, p);
    if (x < p) return Result(p, x);
  } else {
    for (int i = 2; i <= n; ++i) {
      const int x = Mult(Mult(r, i, p), inv_fact, p);
      if (x < i) return Result(i, x);
    }
  }
  return kNone;
}

int main() {
  int64 n;
  int p, r;
  scanf("%lld%d%d", &n, &p, &r);
  const Result res = (r == 0) ? SolveZero(n, p) : SolveNonzero(n, p, r);
  printf("%d %d\n", res.first, res.second);
  return 0;
}
