// Author: Luka Kalinovcic
#include <algorithm>
#include <cmath>
#include <cstdio>

using namespace std;

int R, N;
char a[53][12];

int NumEmptySeats(int r) {
  int num = 0;
  for (int c = 0; c < 11; ++c) {
    if (a[r][c] == '-') ++num;
  }
  return num;
}

int RowPriority(int r) {
  int dist_to_exit_row = R;
  for (int exit_row : {0, R / 2 + 1, R + 2}) {
    dist_to_exit_row = min(dist_to_exit_row, abs(r - exit_row));
  }
  const int empty_seats = NumEmptySeats(r);
  if (empty_seats == 0) return 0;
  int priority = (r == 1 || r == R / 2 + 2) ? 2000000000 : 1000000000;
  priority += 1000000 * empty_seats;
  priority -= 1000 * dist_to_exit_row;
  priority -= r;
  return priority;
}

int SelectRow() {
  int best_index = 0;
  int best_priority = 0;
  for (int r = 0; r < R + 3; ++r) {
    const int priority = RowPriority(r);
    if (priority > best_priority) {
      best_index = r;
      best_priority = priority;
    }
  }
  return best_index;
}

int SeatPriority(int r, int c, int balance) {
  const int balance_bonus = (balance > 0) ^ (c < 5);
  if (c == 4 || c == 6) return 2 * 5 + balance_bonus;
  if (c == 2 || c == 8) return 2 * 4 + balance_bonus;
  if (c == 0 || c == 10) return 2 * 3 + balance_bonus;
  if (c == 5) return 2 * 2 + balance_bonus;
  if (c == 1 || c == 9) return 2 * 1 + balance_bonus;
  return 0;
}

int GetBalance() {
  int balance = 0;
  for (int r = 0; r < R + 3; ++r) {
    for (int c = 0; c < 11; ++c) {
      if (a[r][c] != '-') continue;
      if (c < 5) {
        --balance;
      } else if (c > 5) {
        ++balance;
      }
    }
  }
  return balance;
}

int SelectSeat(int r) {
  const int balance = GetBalance();
  int best_index = 0;
  int best_priority = 0;
  for (int c = 0; c < 11; ++c) {
    const int priority = SeatPriority(r, c, balance);
    if (a[r][c] == '-' && priority > best_priority) {
      best_priority = priority;
      best_index = c;
    }
  }
  return best_index;
}

int main() {
  scanf("%d%d", &R, &N);
  for (int r = 0; r < R + 3; ++r) {
    scanf("%s", a[r]);
  }
  for (int i = 0; i < N; ++i) {
    const int r = SelectRow();
    const int c = SelectSeat(r);
    a[r][c] = 'a' + i;
  }
  for (int r = 0; r < R + 3; ++r) {
    printf("%s\n", a[r]);
  }
  return 0;
}
