#include <cstdio>
#include <cstring>
#include <cstdlib>
#include <cassert>

#include <set>
#include <map>
#include <vector>
#include <algorithm>
#include <functional>

#include <sstream>
#include <iostream>

using namespace std;
typedef long long llint;
const llint inf = 1000000000000000000LL;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)

#define TRACE(x) cerr << #x << " = " << x << endl
#define _ << " _ " <<

const int MAX = 205;

int r, c;
char w[MAX][MAX];

int n, m;
char M[MAX][MAX];

void rot() {
  static char tmp[MAX][MAX];
  REP(i, n) REP(j, m) tmp[i][j] = M[i][j];
  REP(i, n) REP(j, m) M[j][i] = tmp[i][j];
  swap(n, m);
  REP(i, n) reverse(M[i], M[i] + m);
}

string canonize(int x, int y) {
  string tmp, ret = ",";

  int xx = x; while (w[xx][y] != '#') ++xx;
  int yy = y; while (w[x][yy] != '#') ++yy;

  FOR(i, x, xx) FOR(j, y, yy)
    M[i - x][j - y] = w[i][j];

  n = xx - x;
  m = yy - y;
  REP(it, 4) {
    tmp = "#";
    REP(i, n) {
      REP(j, m) 
	tmp += M[i][j];
      tmp += '#';
    }
    ret = min(ret, tmp);
    rot();
  }

  return ret;
}

int main(void) 
{
  scanf("%d%d", &r, &c);
  REP(i, r) scanf("%s", w[i]);

  set< string > s;
  FOR(i, 1, r) FOR(j, 1, c)
    if (w[i - 1][j] == '#' && w[i][j - 1] == '#' && w[i - 1][j - 1] == '#') 
      s.insert(canonize(i, j));

  printf("%d\n", (int)s.size());

  return 0;
}
